/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.customsink.interceptor;

import cn.thinkingdata.ta.customsink.interceptor.data.TaDataDo;
import cn.thinkingdata.ta.logbus.utils.CommonUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.interceptor.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(TaInterceptor.class);
    private int channelNum = 2;
    private String pluginType;
    protected String configPath;
    private final Context context;
    private final Map<String, List<String>> appIdMap = new HashMap<String, List<String>>();
    private String appidMapAttributeName;
    private String defaultAppId;
    private String sendSequenceAttributeName;
    private boolean isOneToMore = false;
    private boolean isNeedResetValue = false;

    public TaInterceptor(Context context) {
        this.context = context;
        logger.info("=========================================================");
        logger.info(JSON.toJSONString((Object)context));
        logger.info("=========================================================");
    }

    public void initialize() {
        logger.info(" common intercept initialize start ");
        this.channelNum = this.context.getInteger("channelNum", Integer.valueOf(2));
        String appidMap = this.context.getString("appidMap");
        if (StringUtils.isNotBlank((CharSequence)appidMap)) {
            JSONObject json = JSONObject.parseObject((String)appidMap);
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                List list = ((JSONArray)entry.getValue()).toJavaList(String.class);
                this.appIdMap.put(key, list);
            }
            this.isNeedResetValue = true;
        }
        this.defaultAppId = this.context.getString("defaultAppId");
        this.appidMapAttributeName = this.context.getString("appidMapAttributeName");
        this.sendSequenceAttributeName = this.context.getString("sendSequenceAttributeName");
        this.isOneToMore = this.context.getBoolean("isOneToMore", Boolean.valueOf(false));
        if (this.isOneToMore) {
            this.isNeedResetValue = true;
        }
        this.pluginType = this.context.getString("pluginType");
        this.configPath = this.context.getString("interceptorConfigPath");
        logger.info(" common intercept initialize end ");
    }

    public List<Event> intercept(List<Event> events) {
        return events.stream().map(this::intercept).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public abstract TaDataDo transsform(String var1, String var2) throws Exception;

    public abstract List<TaDataDo> transform(String var1, String var2) throws Exception;

    public Event intercept(Event event) {
        String content = new String(event.getBody(), StandardCharsets.UTF_8);
        try {
            TaDataDo taDataDo;
            if (content.trim().length() == 0) {
                event.setBody(new byte[0]);
                return event;
            }
            String sourceName = (String)event.getHeaders().get("sourceName");
            List<TaDataDo> taDataDoList = null;
            if (this.isOneToMore) {
                taDataDoList = this.transform(content, sourceName);
                if (taDataDoList == null || taDataDoList.size() == 0) {
                    event.setBody(new byte[0]);
                    return event;
                }
                taDataDo = taDataDoList.get(0);
            } else {
                taDataDo = this.transsform(content, sourceName);
                if (taDataDo == null) {
                    event.setBody(new byte[0]);
                    return event;
                }
            }
            String type = taDataDo.getType();
            if (type != null) {
                if (type.equals("logbusInterceptorDiscard")) {
                    event.setBody(new byte[0]);
                    return event;
                }
                if (type.equals("logbusInterceptorDiscardByDate")) {
                    event.setBody(new byte[0]);
                    return event;
                }
            }
            Map temp = event.getHeaders();
            JSONObject propertyObj = taDataDo.getPropertyObj();
            String id = StringUtils.isNotBlank((CharSequence)this.sendSequenceAttributeName) && propertyObj != null ? propertyObj.getString(this.sendSequenceAttributeName) : (StringUtils.isNotEmpty((CharSequence)taDataDo.getDistinctId()) ? taDataDo.getDistinctId() : (StringUtils.isNotEmpty((CharSequence)taDataDo.getAccountId()) ? taDataDo.getAccountId() : UUID.randomUUID().toString()));
            String hash = "0";
            if (this.channelNum > 1) {
                int queueIndex = CommonUtil.hashIndexWithMurmur3((String)id, (int)this.channelNum);
                hash = String.valueOf(queueIndex);
            }
            if (this.appIdMap.size() > 0) {
                if (propertyObj != null) {
                    String value = propertyObj.getString(this.appidMapAttributeName);
                    for (Map.Entry<String, List<String>> e : this.appIdMap.entrySet()) {
                        if (!e.getValue().contains(value)) continue;
                        String appId = e.getKey();
                        taDataDo.setAppId(appId);
                        break;
                    }
                }
                if (taDataDo.getAppId() == null) {
                    taDataDo.setAppId(this.defaultAppId);
                }
            }
            temp.put("hash", hash);
            event.setHeaders(temp);
            if (this.isNeedResetValue || !"default".equalsIgnoreCase(this.pluginType)) {
                if (taDataDoList == null) {
                    event.setBody(JSONObject.toJSONString((Object)taDataDo).getBytes(StandardCharsets.UTF_8));
                } else {
                    event.setBody(JSONArray.toJSONString(taDataDoList).getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (JSONException e) {
            logger.error("\u6570\u636e\u5185\u5bb9\uff1a{}", (Object)content);
            logger.error("JSONException is ", (Throwable)e);
            if (e.getMessage().contains("Java heap space")) {
                throw new OutOfMemoryError(e.getMessage());
            }
            event.setBody(new byte[0]);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u5185\u5bb9\uff1a{}", (Object)content);
            logger.error("\u62e6\u622a\u5668\u9519\u8bef:", (Throwable)e);
            event.setBody(new byte[0]);
        }
        return event;
    }

    public void close() {
        logger.info("exit intercept");
    }
}

