/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.customsink.interceptor.impl;

import cn.thinkingdata.ta.customsink.interceptor.TaInterceptor;
import cn.thinkingdata.ta.customsink.interceptor.data.TaDataDo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Context;
import org.apache.flume.interceptor.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInterceptor
extends TaInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultInterceptor.class);
    private final Object customInterceptor;
    private final Method transFrom;
    private final Method transferToList;
    private final String dataType;
    private final boolean isOneToMore;

    public DefaultInterceptor(Context context) {
        super(context);
        this.isOneToMore = context.getBoolean("isOneToMore", Boolean.valueOf(false));
        Object customInterceptor = null;
        Method transFrom = null;
        Method transferToList = null;
        String customInterceptorPath = context.getString("customInterceptor");
        this.dataType = context.getString("dataType");
        try {
            if (StringUtils.isNotBlank((CharSequence)customInterceptorPath)) {
                Class<?> customInterceptorClass = Class.forName(customInterceptorPath);
                transFrom = customInterceptorClass.getDeclaredMethod("transFrom", String.class, String.class);
                if (this.isOneToMore) {
                    transferToList = customInterceptorClass.getDeclaredMethod("transferToList", String.class, String.class);
                }
                customInterceptor = customInterceptorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error(customInterceptorPath + " class not found!", (Throwable)e);
        }
        this.customInterceptor = customInterceptor;
        this.transFrom = transFrom;
        this.transferToList = transferToList;
    }

    @Override
    public TaDataDo transsform(String content, String sourceName) {
        if (this.isOneToMore) {
            return null;
        }
        if (this.customInterceptor != null) {
            try {
                content = JSONObject.toJSONString((Object)this.transFrom.invoke(this.customInterceptor, content, sourceName));
            }
            catch (Exception e) {
                logger.error("\u6570\u636e\u5185\u5bb9\uff1a{}", (Object)content);
                logger.error("\u81ea\u5b9a\u4e49\u89e3\u6790\u5668\u89e3\u6790\u9519\u8bef\uff1a", (Throwable)e);
                return null;
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.dataType) && this.dataType.equals("sensors")) {
            JSONObject json = JSONObject.parseObject((String)content);
            TaDataDo taDataDo = new TaDataDo();
            taDataDo.setAccountId(this.getSensorsAccountId(json));
            taDataDo.setPropertyObj(json.getJSONObject("properties"));
            return taDataDo;
        }
        return (TaDataDo)JSONObject.parseObject((String)content, TaDataDo.class);
    }

    @Override
    public List<TaDataDo> transform(String content, String sourceName) {
        if (!this.isOneToMore) {
            return null;
        }
        if (this.customInterceptor != null && this.transferToList != null) {
            try {
                content = JSONArray.toJSONString((Object)this.transferToList.invoke(this.customInterceptor, content, sourceName));
            }
            catch (Exception e) {
                logger.error("\u6570\u636e\u5185\u5bb9\uff1a{}", (Object)content);
                logger.error("\u81ea\u5b9a\u4e49\u89e3\u6790\u5668\u89e3\u6790\u9519\u8bef\uff1a", (Throwable)e);
                return null;
            }
        }
        return JSONArray.parseArray((String)content, TaDataDo.class);
    }

    private String getSensorsAccountId(JSONObject json) {
        String loginId = json.getString("login_id");
        if (StringUtils.isNotBlank((CharSequence)loginId)) {
            return loginId;
        }
        String anonymousId = json.getString("anonymous_id");
        if (StringUtils.isNotBlank((CharSequence)anonymousId)) {
            return anonymousId;
        }
        String distinctId = json.getString("distinct_id");
        if (StringUtils.isNotBlank((CharSequence)distinctId)) {
            return distinctId;
        }
        String signupOriginalId = json.getJSONObject("properties").getString("$track_signup_original_id");
        if (StringUtils.isNotBlank((CharSequence)signupOriginalId)) {
            return signupOriginalId;
        }
        String originalId = json.getString("original_id");
        if (StringUtils.isNotBlank((CharSequence)originalId)) {
            return originalId;
        }
        return UUID.randomUUID().toString();
    }

    public static void main(String[] args) {
        String content = "{\"#account_id\": 9223372036854775807,\"#time\": \"2019-08-16 08:08:08.000\",\"#distinct_id\": 9223372036854775807,\"#event_name\": \"testbuy\",\"#type\": \"track\",\"properties\": {\"testNumber\": 9223372036854775807}}";
        TaDataDo taDataDo = (TaDataDo)JSONObject.parseObject((String)content, TaDataDo.class);
        System.out.println(JSON.toJSONString((Object)taDataDo));
    }

    public static class Builder
    implements Interceptor.Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private Context context;

        public void configure(Context context) {
            this.context = context;
        }

        public Interceptor build() {
            logger.info("DefaultInterceptor$Bulider Creating interceptor");
            String customInterceptorPath = this.context.getString("customInterceptor");
            if (StringUtils.isBlank((CharSequence)customInterceptorPath)) {
                this.context.put("pluginType", "default");
            }
            return new DefaultInterceptor(this.context);
        }
    }
}

