/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.customsink.monitor;

import cn.thinkingdata.ta.logbus.utils.FlumeUtils;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.flume.Context;
import org.apache.flume.instrumentation.MonitorService;
import org.apache.flume.instrumentation.util.JMXPollUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMonitor
implements MonitorService {
    private static final Logger logger = LoggerFactory.getLogger(CustomMonitor.class);
    private ScheduledExecutorService healthCheckService;

    public void start() {
        logger.info("Starting CustomMonitor");
        if (this.healthCheckService == null || this.healthCheckService.isShutdown() || this.healthCheckService.isTerminated()) {
            this.healthCheckService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("HealthCheck-%d").daemon(true).build());
        }
        this.healthCheckService.scheduleAtFixedRate(new HealthCheck(), 0L, 3L, TimeUnit.MINUTES);
        logger.info("CustomMonitor Started");
    }

    public void stop() {
        logger.info("Stopping CustomMonitor");
        if (!this.healthCheckService.isShutdown()) {
            this.healthCheckService.shutdownNow();
        }
    }

    public void configure(Context context) {
    }

    private static class HealthCheck
    implements Runnable {
        private HealthCheck() {
        }

        @Override
        public void run() {
            Map metricsMap = JMXPollUtil.getAllMBeans();
            StringBuilder stringBuilder = new StringBuilder("============flume\u72b6\u6001\u67e5\u8be2\u5f00\u59cb==============\n");
            for (Map.Entry entry : metricsMap.entrySet()) {
                stringBuilder.append("name:").append((String)entry.getKey()).append("\n");
                stringBuilder.append(((Map)entry.getValue()).toString()).append("\n");
                if (Long.parseLong((String)((Map)entry.getValue()).get("StartTime")) < Long.parseLong((String)((Map)entry.getValue()).get("StopTime"))) {
                    logger.info((String)entry.getKey() + " exit, flume need to stop!");
                    FlumeUtils.stopFlume();
                    break;
                }
                if (!"false".equals(((Map)entry.getValue()).get("Open"))) continue;
                logger.info((String)entry.getKey() + " exit, flume need to stop!");
                FlumeUtils.stopFlume();
                break;
            }
            stringBuilder.append("============flume\u72b6\u6001\u67e5\u8be2\u7ed3\u675f==============");
            logger.info(stringBuilder.toString());
        }
    }
}

