/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.customsink.monitor;

import cn.thinkingdata.ta.logbus.config.Configure;
import cn.thinkingdata.ta.logbus.config.TaLogBusContents;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkStatistics {
    private static final Logger logger = LoggerFactory.getLogger(SinkStatistics.class);
    private static final Configure conf = Configure.getInstance();
    private final ConcurrentHashMap<String, SinkStatusList> map = new ConcurrentHashMap();
    private static volatile SinkStatistics sinkStatistics;
    private final Timer timer = new Timer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SinkStatistics getInstance() {
        if (sinkStatistics != null) return sinkStatistics;
        Class<SinkStatistics> clazz = SinkStatistics.class;
        synchronized (SinkStatistics.class) {
            if (sinkStatistics != null) return sinkStatistics;
            sinkStatistics = new SinkStatistics();
            logger.info("Created instance of SinkStatistics.");
            // ** MonitorExit[var0] (shouldn't be in output)
            return sinkStatistics;
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private SinkStatistics() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    SinkStatistics.this.statistics();
                }
                catch (Throwable t) {
                    logger.error("\u7edf\u8ba1\u4e0a\u4f20\u901f\u5ea6\u9519\u8bef!", t);
                }
            }
        }, 1000L, 30000L);
    }

    public void addSinkStatus(String sinkName, Integer count, Integer networkLatency) {
        SinkStatusList sinkStatusList = this.map.computeIfAbsent(sinkName, k -> new SinkStatusList());
        if (sinkStatusList.size() >= 100) {
            sinkStatusList.removeFirst();
        }
        sinkStatusList.add(new SinkStatus(System.currentTimeMillis(), count, networkLatency));
    }

    private void statistics() {
        HashMap<Object, Integer> sinkCount = new HashMap<Object, Integer>();
        HashMap<Object, Integer> sinkNetworkLatency = new HashMap<Object, Integer>();
        for (Map.Entry<String, SinkStatusList> entry : this.map.entrySet()) {
            String sinkName = entry.getKey();
            SinkStatusList sinkStatusList = entry.getValue();
            LinkedList<SinkStatus> list = sinkStatusList.cloneList();
            int listSize = list.size();
            if (listSize == 0 || listSize == 1) {
                sinkCount.put(sinkName, 0);
                sinkNetworkLatency.put(sinkName, 0);
                continue;
            }
            long lastTime = list.getLast().time;
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastTime > 60000L) {
                sinkCount.put(sinkName, 0);
                sinkNetworkLatency.put(sinkName, 0);
                continue;
            }
            int networkLatencySum = 0;
            int countSum = 0;
            ListIterator<SinkStatus> it = list.listIterator(0);
            while (it.hasNext()) {
                SinkStatus next = it.next();
                if (currentTime - next.time > 60000L) {
                    it.remove();
                    continue;
                }
                networkLatencySum += next.networkLatency.intValue();
                countSum += next.count.intValue();
            }
            int timeDifferenceSecond = (int)(lastTime - list.getFirst().time) / 1000;
            if (timeDifferenceSecond == 0) {
                sinkCount.put(sinkName, 0);
                sinkNetworkLatency.put(sinkName, 0);
                continue;
            }
            int countAverage = countSum / timeDifferenceSecond;
            sinkCount.put(sinkName, countAverage);
            int networkLatencyAverage = networkLatencySum / sinkStatusList.size();
            sinkNetworkLatency.put(sinkName, networkLatencyAverage);
        }
        if (sinkCount.size() == 0) {
            return;
        }
        JSONObject json = new JSONObject();
        List sourceList = conf.getSourceList();
        for (String sourceName : sourceList) {
            JSONObject sourceJSON = new JSONObject();
            List sinkNameList = (List)conf.getSinkMap().get(sourceName);
            AtomicInteger countSum = new AtomicInteger();
            AtomicInteger networkLatencySum = new AtomicInteger();
            for (String sinkName : sinkNameList) {
                JSONObject sinkJSON = new JSONObject();
                int count = sinkCount.getOrDefault(sinkName, 0);
                sinkJSON.put("count", (Object)count);
                countSum.addAndGet(count);
                int networkLatency = sinkNetworkLatency.getOrDefault(sinkName, 0);
                sinkJSON.put("networkLatency", (Object)networkLatency);
                networkLatencySum.addAndGet(networkLatency);
                logger.info(String.format("sink: %s, \u5e73\u5747\u4e0a\u4f20\u901f\u5ea6: %d/s, \u5e73\u5747\u7f51\u7edc\u5ef6\u65f6: %dms", sinkName, count, networkLatency));
                sourceJSON.put(sinkName, (Object)sinkJSON);
            }
            logger.info(String.format("source: %s, \u4e0a\u4f20\u901f\u5ea6: %d/s, \u5e73\u5747\u7f51\u7edc\u5ef6\u65f6: %dms", sourceName, countSum.intValue(), networkLatencySum.intValue() / sinkNameList.size()));
            json.put(sourceName, (Object)sourceJSON);
        }
        File progress = new File(TaLogBusContents.SPEED_FILE);
        try {
            FileUtils.write((File)progress, (CharSequence)json.toJSONString(), (String)"UTF-8", (boolean)false);
        }
        catch (IOException e) {
            logger.error("\u5199\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    private static class SinkStatus {
        final Long time;
        final Integer count;
        final Integer networkLatency;

        SinkStatus(Long time, Integer count, Integer networkLatency) {
            this.time = time;
            this.count = count;
            this.networkLatency = networkLatency;
        }
    }

    private static final class SinkStatusList {
        LinkedList<SinkStatus> list = new LinkedList();
        final Object lock = new Object();

        private SinkStatusList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int size() {
            Object object = this.lock;
            synchronized (object) {
                return this.list.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeFirst() {
            Object object = this.lock;
            synchronized (object) {
                this.list.removeFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(SinkStatus o) {
            Object object = this.lock;
            synchronized (object) {
                this.list.addLast(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LinkedList<SinkStatus> cloneList() {
            Object object = this.lock;
            synchronized (object) {
                LinkedList<SinkStatus> clone = new LinkedList<SinkStatus>();
                ListIterator<SinkStatus> it = this.list.listIterator(0);
                while (it.hasNext()) {
                    SinkStatus next = it.next();
                    clone.add(next);
                }
                return clone;
            }
        }
    }
}

