/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.customsink.sink.http;

import cn.thinkingdata.ta.customsink.sink.http.SuccessPositionWriter;
import cn.thinkingdata.ta.logbus.utils.CommonUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSuccessPositionWriter
extends SuccessPositionWriter {
    private static final Logger logger = LoggerFactory.getLogger(FileSuccessPositionWriter.class);
    private static final Map<String, FileSuccessPositionWriter> TASK_MAP = new ConcurrentHashMap<String, FileSuccessPositionWriter>();
    private final String successPositionFilePath;
    private final String tempPositionFilePath;
    private final String appId;
    private final Map<String, List<Offset>> filePositionMap = new ConcurrentHashMap<String, List<Offset>>();
    private final Map<String, Set<Long>> sentBeginOffsetMap = new ConcurrentHashMap<String, Set<Long>>();
    private final Map<String, AtomicInteger> markMap = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, Long> positionMap = new ConcurrentHashMap<String, Long>();
    private AtomicInteger sentOffsetSize = new AtomicInteger();
    private boolean isSentFlag = false;
    private List<String> needRemoveKeys = new ArrayList<String>();
    private final Object setEventListLock = new Object();
    private final List<Event> sentEventList = new ArrayList<Event>();
    private boolean isClosed = false;
    private final ScheduledThreadPoolExecutor positionWriter;
    private final ScheduledThreadPoolExecutor removePosition;
    private final ScheduledThreadPoolExecutor savePosition;

    private FileSuccessPositionWriter(Context context) {
        this.appId = context.getString("appid");
        this.successPositionFilePath = context.getString("successPositionFile");
        Path successPositionFile = Paths.get(this.successPositionFilePath, new String[0]);
        try {
            Files.createDirectories(successPositionFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FlumeException("Error creating successPositionFile parent directories", (Throwable)e);
        }
        this.positionMap.putAll(CommonUtil.loadPositionFile((String)this.successPositionFilePath));
        this.tempPositionFilePath = context.getString("tempPositionFile");
        File tempPath = new File(this.tempPositionFilePath);
        if (tempPath.exists()) {
            try {
                String s = FileUtils.readFileToString((File)tempPath, (Charset)StandardCharsets.UTF_8);
                JSONObject json = JSONObject.parseObject((String)s);
                for (Map.Entry entry : json.entrySet()) {
                    String path = (String)entry.getKey();
                    Object v = entry.getValue();
                    LinkedList offsets = ((JSONArray)v).toJavaList(Offset.class);
                    offsets = new LinkedList(offsets);
                    this.filePositionMap.put(path, offsets);
                    this.sentBeginOffsetMap.put(path, offsets.stream().map(Offset::getBeginOffset).collect(Collectors.toSet()));
                }
                this.sentOffsetSize = new AtomicInteger(this.sentBeginOffsetMap.size());
                tempPath.delete();
            }
            catch (Exception e) {
                logger.error("Failed reading successPositionFile", (Throwable)e);
            }
            if (this.sentBeginOffsetMap.size() > 0) {
                this.isSentFlag = true;
            }
        }
        this.positionWriter = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("SuccessPositionWriter-" + this.appId).build());
        this.positionWriter.scheduleWithFixedDelay(new PositionWriterRunnable(), 1000L, 1L, TimeUnit.MILLISECONDS);
        this.removePosition = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("RemovePosition-" + this.appId).build());
        this.removePosition.scheduleWithFixedDelay(new RemovePositionRunnable(), 1L, 60L, TimeUnit.MINUTES);
        this.savePosition = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("SavePosition-" + this.appId).build());
        this.savePosition.scheduleWithFixedDelay(new SavePositionRunnable(), 3L, 10L, TimeUnit.SECONDS);
        logger.info("Created SuccessPositionWriter appid:" + this.appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSuccessPositionWriter getSendSuccessTask(Context context) {
        String appid = context.getString("appid");
        FileSuccessPositionWriter fileSuccessPositionWriter = TASK_MAP.get(appid);
        if (fileSuccessPositionWriter == null) {
            Map<String, FileSuccessPositionWriter> map = TASK_MAP;
            synchronized (map) {
                fileSuccessPositionWriter = TASK_MAP.get(appid);
                if (fileSuccessPositionWriter == null) {
                    fileSuccessPositionWriter = TASK_MAP.computeIfAbsent(appid, k -> new FileSuccessPositionWriter(context));
                }
            }
        }
        return fileSuccessPositionWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addList(List<Event> eventList) {
        Object object = this.setEventListLock;
        synchronized (object) {
            while (this.sentEventList.size() > 100000) {
                try {
                    logger.info("\u6570\u636e\u7f13\u5b58\u6709\u79ef\u538b\uff0c\u6682\u7f13\u4f20\u8f93\uff01");
                    this.setEventListLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.sentEventList.addAll(eventList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCurrentPosition() {
        String path;
        ArrayList<Event> eventList;
        Iterator<Object> iterator = this.setEventListLock;
        synchronized (iterator) {
            if (this.sentEventList.size() == 0) {
                return;
            }
            eventList = new ArrayList<Event>(this.sentEventList);
            this.sentEventList.clear();
            this.setEventListLock.notifyAll();
        }
        for (Event event : eventList) {
            path = (String)event.getHeaders().get("PATH");
            List offsets = this.filePositionMap.computeIfAbsent(path, k -> new LinkedList());
            offsets.add(new Offset(Long.parseLong((String)event.getHeaders().get("BEGIN_POS")), Long.parseLong((String)event.getHeaders().get("END_POS"))));
        }
        for (Map.Entry entry : this.filePositionMap.entrySet()) {
            path = (String)entry.getKey();
            List value = (List)entry.getValue();
            value = value.stream().filter(Objects::nonNull).sorted(Comparator.comparingLong(o -> o.beginOffset)).collect(Collectors.toCollection(LinkedList::new));
            Long pos = this.positionMap.computeIfAbsent(path, v -> 0L);
            Iterator iterator2 = value.iterator();
            while (iterator2.hasNext()) {
                Offset offset = (Offset)iterator2.next();
                if (offset.beginOffset.equals(pos)) {
                    pos = offset.endOffset;
                    iterator2.remove();
                    continue;
                }
                if (offset.endOffset > pos) break;
                iterator2.remove();
            }
            this.positionMap.put(path, pos);
            if (value.size() == 0) {
                this.filePositionMap.remove(path);
                continue;
            }
            this.filePositionMap.put(path, value);
        }
        logger.info(this.appId + ": save event size:" + eventList.size());
    }

    public void remove() {
        if (this.needRemoveKeys.size() > 0) {
            for (String key : this.needRemoveKeys) {
                this.positionMap.remove(key);
                this.filePositionMap.remove(key);
                this.sentBeginOffsetMap.remove(key);
                this.markMap.remove(key);
            }
        }
        ArrayList<String> needRemoveKeys = new ArrayList<String>();
        for (String path : this.positionMap.keySet()) {
            File file = new File(path);
            if (file.exists()) continue;
            needRemoveKeys.add(path);
        }
        this.needRemoveKeys = needRemoveKeys;
    }

    @Override
    public boolean isSent(Event event) {
        if (!this.isSentFlag) {
            return false;
        }
        String path = (String)event.getHeaders().get("PATH");
        Set<Long> offsetList = this.sentBeginOffsetMap.get(path);
        if (offsetList == null || offsetList.size() == 0) {
            return false;
        }
        Long beginOffset = Long.parseLong((String)event.getHeaders().get("BEGIN_POS"));
        if (offsetList.contains(beginOffset)) {
            AtomicInteger atomicInteger = this.markMap.computeIfAbsent(path, k -> new AtomicInteger());
            atomicInteger.getAndIncrement();
            if (atomicInteger.intValue() == offsetList.size()) {
                this.sentBeginOffsetMap.remove(path);
                this.markMap.remove(path);
                if (this.sentOffsetSize.getAndDecrement() <= 0) {
                    this.isSentFlag = false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            logger.info(this.appId + ":SuccessPositionWriter had Closed!");
            return;
        }
        try {
            ExecutorService[] services;
            logger.info(this.appId + ":SuccessPositionWriter Closing!");
            for (ExecutorService service : services = new ExecutorService[]{this.positionWriter, this.removePosition, this.savePosition}) {
                service.shutdown();
                if (service.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                service.shutdownNow();
            }
            while (true) {
                try {
                    this.saveCurrentPosition();
                    this.savePositionFile();
                    this.saveTempPosition();
                }
                catch (Throwable t) {
                    logger.error("close \u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff01", t);
                    continue;
                }
                break;
            }
            this.isClosed = true;
            logger.info(this.appId + ":SuccessPositionWriter Closed!");
        }
        catch (InterruptedException e) {
            logger.info("Interrupted while awaiting termination", (Throwable)e);
        }
    }

    private void saveTempPosition() throws IOException {
        File file = new File(this.tempPositionFilePath);
        if (this.filePositionMap.size() != 0) {
            FileUtils.write((File)file, (CharSequence)JSONObject.toJSONString(this.filePositionMap), (String)"UTF-8", (boolean)false);
        }
    }

    private void savePositionFile() throws IOException {
        CommonUtil.savePositionFile((String)this.successPositionFilePath, this.positionMap);
    }

    private static class Offset {
        Long beginOffset;
        Long endOffset;

        Offset() {
        }

        Offset(Long beginOffset, Long endOffset) {
            this.beginOffset = beginOffset;
            this.endOffset = endOffset;
        }

        public void setBeginOffset(Long beginOffset) {
            this.beginOffset = beginOffset;
        }

        public Long getBeginOffset() {
            return this.beginOffset;
        }

        public void setEndOffset(Long endOffset) {
            this.endOffset = endOffset;
        }

        public Long getEndOffset() {
            return this.endOffset;
        }
    }

    private class SavePositionRunnable
    implements Runnable {
        private SavePositionRunnable() {
        }

        @Override
        public void run() {
            try {
                FileSuccessPositionWriter.this.savePositionFile();
            }
            catch (Throwable t) {
                logger.error("\u4fdd\u5b58position\u5931\u8d25\uff01", t);
            }
        }
    }

    private class RemovePositionRunnable
    implements Runnable {
        private RemovePositionRunnable() {
        }

        @Override
        public void run() {
            logger.info("=======\u5b9a\u65f6\u6e05\u7406\u4efb\u52a1\u5f00\u59cb=======");
            try {
                FileSuccessPositionWriter.this.remove();
            }
            catch (Throwable t) {
                logger.error("\u5b9a\u65f6\u6e05\u7406\u4efb\u52a1\u51fa\u73b0\u9519\u8bef!", t);
            }
            logger.info("=======\u5b9a\u65f6\u6e05\u7406\u4efb\u52a1\u5b8c\u6210=======");
        }
    }

    private class PositionWriterRunnable
    implements Runnable {
        private PositionWriterRunnable() {
        }

        @Override
        public void run() {
            try {
                FileSuccessPositionWriter.this.saveCurrentPosition();
            }
            catch (Throwable t) {
                logger.error("\u66f4\u65b0position\u5931\u8d25\uff01", t);
            }
        }
    }
}

