/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.customsink.sink.http;

import cn.thinkingdata.ta.customsink.monitor.SinkStatistics;
import cn.thinkingdata.ta.customsink.sink.http.FileSuccessPositionWriter;
import cn.thinkingdata.ta.customsink.sink.http.SuccessPositionWriter;
import cn.thinkingdata.ta.logbus.utils.CommonLock;
import cn.thinkingdata.ta.logbus.utils.CommonUtil;
import cn.thinkingdata.ta.logbus.utils.CompressUtil;
import cn.thinkingdata.ta.logbus.utils.FlumeUtils;
import cn.thinkingdata.ta.logbus.utils.HttpRequestUtil;
import cn.thinkingdata.ta.logbus.utils.UUIDUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.flume.sink.AbstractSink;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSink
extends AbstractSink
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(HttpSink.class);
    private String appid;
    private boolean appidInData;
    private int batchSize;
    private String posturl;
    private long intervalDatetime = 60L;
    private String compress = "gzip";
    private boolean isAddUuid;
    private String importToolId;
    private int retryTimes = -1;
    private int retryCnt = 0;
    private CloseableHttpClient httpClient = null;
    private SinkCounter sinkCounter;
    private static final long MAX_SLEEP = 3L;
    private boolean isMemory = false;
    private boolean checkStateFlag = false;
    private boolean isCanStop = false;
    private SuccessPositionWriter successPositionWriter;
    private SinkStatistics sinkStatistics;
    private boolean resetFlag = false;
    private int noDataTimes = 0;
    private ScheduledExecutorService checkStateFileService;
    private ScheduledExecutorService resetCheckService;
    private String dataType;

    public void configure(Context context) {
        this.batchSize = context.getInteger("batchSize", Integer.valueOf(500));
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)"batchSize must be a positive number!!!");
        this.posturl = context.getString("posturl").trim().replace("/logagent", "/logbus");
        Preconditions.checkNotNull((Object)this.posturl, (Object)"posturl must be set!!!");
        this.appid = context.getString("appid").trim();
        this.appidInData = context.getBoolean("appid_in_data", Boolean.valueOf(false));
        if (!this.appidInData) {
            Preconditions.checkNotNull((Object)this.appid, (Object)"appid must be set!!!");
        }
        this.intervalDatetime = context.getLong("intervalDatetime", Long.valueOf(60L));
        this.retryTimes = context.getInteger("retrytimes", Integer.valueOf(-1));
        this.isMemory = context.getBoolean("isMemory", Boolean.valueOf(false));
        this.httpClient = HttpRequestUtil.getConnection();
        if (StringUtils.isNotBlank((CharSequence)context.getString("successPositionFile")) && "tailDirSource".equals(context.getString("sourceType"))) {
            this.successPositionWriter = FileSuccessPositionWriter.getSendSuccessTask(context);
        }
        this.compress = context.getString("compress");
        this.isAddUuid = context.getBoolean("isAddUuid", Boolean.valueOf(false));
        this.importToolId = context.getString("importToolId");
        this.resetFlag = CommonUtil.getResetFlagByFile();
        this.dataType = context.getString("dataType");
        if (this.sinkCounter == null) {
            this.sinkCounter = new SinkCounter(this.getName());
        }
        this.sinkStatistics = SinkStatistics.getInstance();
        logger.info("\u6570\u636e\u538b\u7f29\u683c\u5f0f:" + this.compress);
    }

    public void start() {
        logger.info("Starting  sink {} ...", (Object)this.getName());
        if (this.sinkCounter == null) {
            this.sinkCounter = new SinkCounter(this.getName());
        }
        this.checkStateFileService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("HttpSink-CheckStateFileService-%d").daemon(true).build());
        this.checkStateFileService.scheduleWithFixedDelay(new CheckStateFileRunnable(), 5L, 3L, TimeUnit.SECONDS);
        if (this.resetFlag) {
            this.resetCheckService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("HttpSink-ResetCheckService-%d").daemon(true).build());
            this.resetCheckService.scheduleWithFixedDelay(new ResetCheckRunnable(), 0L, 1L, TimeUnit.MINUTES);
        }
        this.sinkCounter.start();
        super.start();
        logger.info("Sink {} started.", (Object)this.getName());
        CommonLock.recordStartCounter((String)this.getName());
        if (this.resetFlag) {
            CommonLock.recordStartResetCounter((String)this.getName());
        }
    }

    public void stop() {
        logger.info("Stopping sink {} ...", (Object)this.getName());
        this.checkStateFlag = true;
        int count = 0;
        while (!this.isCanStop && count < 300) {
            try {
                Thread.sleep(1000L);
                ++count;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.sinkCounter.stop();
        super.stop();
        this.sinkCounter.incrementConnectionClosedCount();
        if (this.checkStateFileService != null && !this.checkStateFileService.isShutdown()) {
            this.checkStateFileService.shutdownNow();
        }
        if (this.resetCheckService != null && !this.resetCheckService.isShutdown()) {
            this.resetCheckService.shutdownNow();
        }
        this.sinkStatistics.stop();
        if (this.successPositionWriter != null) {
            this.successPositionWriter.close();
        }
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        logger.info("Sink {} stopped.", (Object)this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink.Status process() {
        Sink.Status status = Sink.Status.BACKOFF;
        if (this.checkStateFlag && !this.isMemory) {
            CommonLock.recordStopCounter((String)this.getName());
            this.isCanStop = true;
            return Sink.Status.BACKOFF;
        }
        Channel ch = this.getChannel();
        if (ch.getLifecycleState().compareTo((Enum)LifecycleState.START) != 0) {
            return Sink.Status.BACKOFF;
        }
        Transaction txn = ch.getTransaction();
        long pushDatetime = System.currentTimeMillis();
        try {
            txn.begin();
            ArrayList<String> contents = new ArrayList<String>();
            ArrayList<Event> events = new ArrayList<Event>();
            int eventAttemptCounter = 0;
            while (eventAttemptCounter < this.batchSize && (System.currentTimeMillis() - pushDatetime) / 1000L < this.intervalDatetime) {
                Object eventBody;
                Event event = ch.take();
                if (event != null) {
                    if (this.successPositionWriter != null && this.successPositionWriter.isSent(event)) {
                        ++eventAttemptCounter;
                        this.sinkCounter.incrementEventDrainAttemptCount();
                        continue;
                    }
                    this.sinkCounter.incrementEventDrainAttemptCount();
                    eventBody = event.getBody();
                    String line = new String((byte[])eventBody, StandardCharsets.UTF_8);
                    if (line.length() != 0) {
                        contents.add(line);
                    }
                    events.add(event);
                    ++eventAttemptCounter;
                } else {
                    if (eventAttemptCounter == 0) {
                        this.sinkCounter.incrementBatchEmptyCount();
                        if (!this.checkStateFlag) break;
                        CommonLock.recordStopCounter((String)this.getName());
                        this.isCanStop = true;
                        txn.commit();
                        eventBody = Sink.Status.BACKOFF;
                        return eventBody;
                    }
                    this.sinkCounter.incrementBatchUnderflowCount();
                    if (this.checkStateFlag) break;
                    TimeUnit.MILLISECONDS.sleep(3L);
                }
                if (Thread.currentThread().isInterrupted()) break;
                if (!this.checkStateFlag || this.isMemory) continue;
                contents.clear();
                txn.rollback();
                CommonLock.recordStopCounter((String)this.getName());
                this.isCanStop = true;
                eventBody = Sink.Status.BACKOFF;
                return eventBody;
            }
            if (this.resetFlag) {
                this.noDataTimes = eventAttemptCounter == 0 ? ++this.noDataTimes : 0;
            }
            if (eventAttemptCounter > 0 && contents.size() > 0) {
                int retryCount = 0;
                byte[] data = this.encodeRecord(contents);
                long beginTime = System.currentTimeMillis();
                while (true) {
                    try {
                        this.httpSuccess(data, contents.size());
                    }
                    catch (Exception e) {
                        if (this.checkStateFlag) {
                            if (!this.isMemory) {
                                logger.error("Error sending but flume is stopping", (Throwable)e);
                                CommonLock.recordStopCounter((String)this.getName());
                                this.isCanStop = true;
                                throw e;
                            }
                            if (retryCount > 9) {
                                logger.error("Error sending but flume is stopping", (Throwable)e);
                                CommonLock.recordStopCounter((String)this.getName());
                                this.isCanStop = true;
                                throw e;
                            }
                        }
                        ++retryCount;
                        logger.error("Error sending , retrying", (Throwable)e);
                        continue;
                    }
                    break;
                }
                int networkLatency = (int)(System.currentTimeMillis() - beginTime);
                logger.info(this.getName() + "\u5b8c\u6210\u4f20\u8f93\u6570\u636e:" + contents.size() + ", \u538b\u7f29\u683c\u5f0f:" + this.compress + ", appid:" + this.appid + ", \u8017\u65f6:" + networkLatency + "ms");
                if (this.successPositionWriter != null) {
                    this.successPositionWriter.addList(events);
                }
                this.sinkStatistics.addSinkStatus(this.getName(), contents.size(), networkLatency);
                status = Sink.Status.READY;
            }
            txn.commit();
            this.sinkCounter.addToEventDrainSuccessCount((long)eventAttemptCounter);
            if (this.checkStateFlag && !this.isMemory) {
                CommonLock.recordStopCounter((String)this.getName());
                this.isCanStop = true;
            }
            Sink.Status status2 = status;
            return status2;
        }
        catch (Throwable t) {
            logger.error("sink error:", t);
            try {
                txn.rollback();
            }
            catch (Throwable rollback) {
                logger.error("Exception in rollback. Rollback might not be successful.", rollback);
            }
            Sink.Status status3 = Sink.Status.BACKOFF;
            return status3;
        }
        finally {
            try {
                txn.close();
            }
            catch (Exception e) {
                logger.error("Exception in close. txn might not be closed.", (Throwable)e);
            }
        }
    }

    private void httpSuccess(byte[] data, int size) throws Exception {
        HttpPost request = null;
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            UrlEncodedFormEntity entity;
            this.sinkCounter.incrementConnectionCreatedCount();
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(600000).setConnectTimeout(300000).build();
            request = new HttpPost(this.posturl);
            request.addHeader("user-agent", "logbus-1.5.17.1");
            request.setConfig(requestConfig);
            if ("sensors".equals(this.dataType)) {
                request.addHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                list.add(new BasicNameValuePair("project", this.appid));
                if ("gzip".equalsIgnoreCase(this.compress)) {
                    list.add(new BasicNameValuePair("gzip", "1"));
                }
                list.add(new BasicNameValuePair("data_list", new String(data)));
                entity = new UrlEncodedFormEntity(list);
                request.setEntity((HttpEntity)entity);
            } else {
                if (this.appidInData) {
                    request.addHeader("custom_appid", "true");
                } else {
                    request.addHeader("appid", this.appid);
                }
                request.addHeader("TA-Integration-Type", "logbus");
                request.addHeader("TA-Integration-Version", "1.5.17.1");
                request.addHeader("TA-Integration-Count", String.valueOf(size));
                request.addHeader("TA-Integration-Extra", System.getProperty("os.name") + "/flume");
                request.addHeader("compress", this.compress);
                request.setEntity((HttpEntity)new ByteArrayEntity(data));
            }
            closeableHttpResponse = this.httpClient.execute((HttpUriRequest)request);
            int returnCode = closeableHttpResponse.getStatusLine().getStatusCode();
            if (returnCode != 200) {
                throw new Exception("http post with error code is " + returnCode + " ,please check data receiver " + this.posturl);
            }
            entity = closeableHttpResponse.getEntity();
            if (entity != null) {
                String item = EntityUtils.toString((HttpEntity)(entity = new BufferedHttpEntity((HttpEntity)entity)));
                JSONObject obj = JSONObject.parseObject((String)item);
                Integer status = obj.getInteger("code");
                if (status != 0) {
                    if (status == -1) {
                        if (this.retryTimes == 0) {
                            logger.error("http response with  code is " + status + " ,retryTimes is " + this.retryTimes + ",This batch of data will be discarded!");
                        }
                        if (this.retryTimes == -1) {
                            throw new Exception("http response with  code is " + status + " ,retryTimes is " + this.retryTimes + " ,this batch will retry!");
                        }
                        if (this.retryCnt < this.retryTimes) {
                            ++this.retryCnt;
                            throw new Exception("http response with  code is " + status + " ,retryTimes is " + this.retryTimes + ",this is " + this.retryCnt + ",this batch will retry!");
                        }
                        ++this.retryCnt;
                        logger.error("http response with  code is " + status + " ,retryTimes is " + this.retryTimes + ",this is " + this.retryCnt + ",This batch of data will be discarded!");
                        this.retryCnt = 0;
                    } else {
                        logger.error("http post with error ,please check data  , return code is {}.", (Object)status);
                    }
                } else {
                    this.retryCnt = 0;
                }
            }
        }
        catch (Exception e) {
            this.sinkCounter.incrementConnectionFailedCount();
            throw e;
        }
        finally {
            if (request != null) {
                request.abort();
            }
            if (closeableHttpResponse != null) {
                try {
                    closeableHttpResponse.close();
                    this.sinkCounter.incrementConnectionClosedCount();
                }
                catch (IOException e) {
                    logger.error("release connection with error:", (Throwable)e);
                }
            }
        }
    }

    private byte[] encodeRecord(List<String> contents) throws IOException {
        byte[] dataCompressed;
        JSONArray jsonArray = new JSONArray();
        for (String item : contents) {
            try {
                if (item.startsWith("{")) {
                    JSONObject json = JSONObject.parseObject((String)item);
                    if (this.isAddUuid && StringUtils.isBlank((CharSequence)json.getString("#uuid"))) {
                        json.put("#uuid", (Object)UUIDUtils.jdk8ThreadLocalRandomUUId());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.importToolId) && StringUtils.equalsAny((CharSequence)json.getString("#type"), (CharSequence[])new CharSequence[]{"track", "track_overwrite", "track_update"})) {
                        json.put("#import_tool_id", (Object)this.importToolId);
                    }
                    jsonArray.add((Object)json);
                    continue;
                }
                if (!item.startsWith("[")) continue;
                JSONArray jsonList = JSONArray.parseArray((String)item);
                for (int i = 0; i < jsonList.size(); ++i) {
                    JSONObject data = jsonList.getJSONObject(i);
                    if (this.isAddUuid && StringUtils.isBlank((CharSequence)data.getString("#uuid"))) {
                        data.put("#uuid", (Object)UUIDUtils.jdk8ThreadLocalRandomUUId());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.importToolId) && StringUtils.equalsAny((CharSequence)data.getString("#type"), (CharSequence[])new CharSequence[]{"track", "track_overwrite", "track_update"})) {
                        data.put("#import_tool_id", (Object)this.importToolId);
                    }
                    jsonArray.add((Object)data);
                }
            }
            catch (Throwable e) {
                logger.error("json format is error ,content is {}", (Object)item, (Object)e);
            }
        }
        String data = jsonArray.toString();
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        if ("sensors".equals(this.dataType)) {
            dataCompressed = "gzip".equalsIgnoreCase(this.compress) ? CompressUtil.gzipCompress((byte[])dataBytes) : dataBytes;
            dataCompressed = Base64.encodeBase64((byte[])dataCompressed);
        } else {
            dataCompressed = "gzip".equalsIgnoreCase(this.compress) ? CompressUtil.gzipCompress((byte[])dataBytes) : ("lzo".equalsIgnoreCase(this.compress) ? CompressUtil.lzoCompress((byte[])dataBytes) : ("lz4".equalsIgnoreCase(this.compress) ? CompressUtil.lz4Compress((byte[])dataBytes) : ("snappy".equalsIgnoreCase(this.compress) ? CompressUtil.snappyCompress((byte[])dataBytes) : dataBytes)));
        }
        return dataCompressed;
    }

    private class ResetCheckRunnable
    implements Runnable {
        private boolean flag = true;

        private ResetCheckRunnable() {
        }

        @Override
        public void run() {
            if (this.flag) {
                String channelName = "c" + HttpSink.this.getName().substring(1);
                double percentage = FlumeUtils.getChannelFillPercentageByName((String)channelName);
                logger.info("channel:" + channelName + " \u672a\u6d88\u8d39\u6bd4\u4f8b\u4e3a\uff1a" + percentage);
                if (percentage == 0.0 && HttpSink.this.noDataTimes > 0) {
                    this.flag = !CommonLock.recordStopResetCounter((String)HttpSink.this.getName());
                }
            }
        }
    }

    private class CheckStateFileRunnable
    implements Runnable {
        private CheckStateFileRunnable() {
        }

        @Override
        public void run() {
            try {
                if (!HttpSink.this.checkStateFlag) {
                    HttpSink.this.checkStateFlag = CommonLock.checkStateFile();
                    if (HttpSink.this.checkStateFlag) {
                        logger.info(HttpSink.this.getName() + " \u6536\u5230\u505c\u6b62\u4fe1\u53f7\uff01");
                    }
                }
            }
            catch (Exception e) {
                logger.error("CheckStateFileRunnable Exception is :" + e.getMessage());
            }
        }
    }
}

