/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.customsink.sink.http;

import cn.thinkingdata.ta.customsink.sink.http.KafkaInfo;
import cn.thinkingdata.ta.customsink.sink.http.SuccessPositionWriter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSuccessPositionWriter
extends SuccessPositionWriter {
    private static final Logger logger = LoggerFactory.getLogger(KafkaSuccessPositionWriter.class);
    private static final Map<String, KafkaSuccessPositionWriter> TASK_MAP = new ConcurrentHashMap<String, KafkaSuccessPositionWriter>();
    private final String successPositionFilePath;
    private final String tempPositionFilePath;
    private final Map<String, List<Long>> filePositionMap = new ConcurrentHashMap<String, List<Long>>();
    private final Map<String, Set<Long>> sentBeginOffsetMap = new ConcurrentHashMap<String, Set<Long>>();
    private final Map<String, AtomicInteger> markMap = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, Long> positionMap = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> startOffsetMap = new HashMap<String, Long>();
    private AtomicInteger sentOffsetSize = new AtomicInteger();
    private boolean isSentFlag = false;
    private final Object sentEventLock = new Object();
    private final List<Event> sentEventList = new ArrayList<Event>();
    private boolean isClosed = false;
    private final ScheduledThreadPoolExecutor positionWriter;
    private final ScheduledThreadPoolExecutor savePosition;

    private KafkaSuccessPositionWriter(Context context) {
        String appid = context.getString("appid");
        this.successPositionFilePath = context.getString("successPositionFile");
        Path successPositionFile = Paths.get(this.successPositionFilePath, new String[0]);
        try {
            Files.createDirectories(successPositionFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FlumeException("Error creating successPositionFile parent directories", (Throwable)e);
        }
        this.loadPositionFile(this.successPositionFilePath);
        this.tempPositionFilePath = context.getString("tempPositionFile");
        File tempPath = new File(this.tempPositionFilePath);
        if (tempPath.exists()) {
            try {
                String s = FileUtils.readFileToString((File)tempPath, (Charset)StandardCharsets.UTF_8);
                JSONObject json = JSONObject.parseObject((String)s);
                for (Map.Entry entry : json.entrySet()) {
                    String k = (String)entry.getKey();
                    Object v = entry.getValue();
                    LinkedList sentOffsets = ((JSONArray)v).toJavaList(Long.class);
                    sentOffsets = new LinkedList(sentOffsets);
                    this.filePositionMap.put(k, sentOffsets);
                    this.sentBeginOffsetMap.put(k, new HashSet(sentOffsets));
                }
                this.sentOffsetSize = new AtomicInteger(this.sentBeginOffsetMap.size());
                tempPath.delete();
            }
            catch (Exception e) {
                logger.error("Failed reading successPositionFile", (Throwable)e);
            }
            if (this.sentBeginOffsetMap.size() > 0) {
                this.isSentFlag = true;
            }
        }
        this.positionWriter = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("SuccessPositionWriter-" + appid).build());
        this.positionWriter.scheduleWithFixedDelay(new PositionWriterRunnable(), 1000L, 1L, TimeUnit.MILLISECONDS);
        this.savePosition = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("SavePosition-" + appid).build());
        this.savePosition.scheduleWithFixedDelay(new SavePositionRunnable(), 3L, 10L, TimeUnit.SECONDS);
        logger.info("Created SuccessPositionWriter appid:" + appid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KafkaSuccessPositionWriter getSendSuccessTask(Context context) {
        String appid = context.getString("appid");
        KafkaSuccessPositionWriter kafkaSuccessPositionWriter = TASK_MAP.get(appid);
        if (kafkaSuccessPositionWriter == null) {
            Map<String, KafkaSuccessPositionWriter> map = TASK_MAP;
            synchronized (map) {
                kafkaSuccessPositionWriter = TASK_MAP.get(appid);
                if (kafkaSuccessPositionWriter == null) {
                    kafkaSuccessPositionWriter = TASK_MAP.computeIfAbsent(appid, k -> new KafkaSuccessPositionWriter(context));
                }
            }
        }
        return kafkaSuccessPositionWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addList(List<Event> eventList) {
        Object object = this.sentEventLock;
        synchronized (object) {
            while (this.sentEventList.size() > 100000) {
                try {
                    logger.info("\u6570\u636e\u7f13\u5b58\u6709\u79ef\u538b\uff0c\u6682\u7f13\u4f20\u8f93\uff01");
                    this.sentEventLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.sentEventList.addAll(eventList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCurrentPosition() {
        ArrayList<Event> eventList;
        Iterator<Object> iterator = this.sentEventLock;
        synchronized (iterator) {
            if (this.sentEventList.size() == 0) {
                return;
            }
            eventList = new ArrayList<Event>(this.sentEventList);
            this.sentEventList.clear();
            this.sentEventLock.notifyAll();
        }
        for (Event event : eventList) {
            String topic = (String)event.getHeaders().get("topic");
            String partition = (String)event.getHeaders().get("partition");
            String key = topic + "_" + partition;
            this.startOffsetMap.putIfAbsent(key, Long.parseLong((String)event.getHeaders().get("startOffset")));
            List offsets = this.filePositionMap.computeIfAbsent(key, k -> new LinkedList());
            offsets.add(Long.parseLong((String)event.getHeaders().get("offset")));
        }
        for (Map.Entry entry : this.filePositionMap.entrySet()) {
            String key = (String)entry.getKey();
            List list = (List)entry.getValue();
            list = list.stream().filter(Objects::nonNull).sorted().collect(Collectors.toCollection(LinkedList::new));
            Long currentOffset = this.positionMap.get(key);
            if (currentOffset == null) {
                currentOffset = this.startOffsetMap.get(key);
            }
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Long offset = (Long)iterator2.next();
                if (offset == currentOffset + 1L) {
                    currentOffset = offset;
                    iterator2.remove();
                    continue;
                }
                if (offset > currentOffset) break;
                iterator2.remove();
            }
            this.positionMap.put(key, currentOffset);
            if (list.size() == 0) {
                this.filePositionMap.remove(key);
                continue;
            }
            this.filePositionMap.put(key, list);
        }
        logger.info("save event size:" + eventList.size());
    }

    @Override
    public boolean isSent(Event event) {
        if (!this.isSentFlag) {
            return false;
        }
        String partition = (String)event.getHeaders().get("partition");
        String topic = (String)event.getHeaders().get("topic");
        String key = topic + "_" + partition;
        Set<Long> offsetList = this.sentBeginOffsetMap.get(key);
        if (offsetList == null || offsetList.size() == 0) {
            return false;
        }
        Long offset = Long.parseLong((String)event.getHeaders().get("offset"));
        if (offsetList.contains(offset)) {
            AtomicInteger atomicInteger = this.markMap.computeIfAbsent(key, k -> new AtomicInteger());
            atomicInteger.getAndIncrement();
            if (atomicInteger.intValue() == offsetList.size()) {
                this.sentBeginOffsetMap.remove(key);
                this.markMap.remove(key);
                if (this.sentOffsetSize.getAndDecrement() <= 0) {
                    this.isSentFlag = false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            logger.info("SuccessPositionWriter had Closed!");
            return;
        }
        try {
            ExecutorService[] services;
            for (ExecutorService service : services = new ExecutorService[]{this.positionWriter, this.savePosition}) {
                service.shutdown();
                if (service.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                service.shutdownNow();
            }
            this.handleCurrentPosition();
            this.savePositionFile();
            this.saveTempPosition();
            this.isClosed = true;
            logger.info("SuccessPositionWriter Closed!");
        }
        catch (InterruptedException e) {
            logger.info("Interrupted while awaiting termination", (Throwable)e);
        }
    }

    private void saveTempPosition() {
        File file = new File(this.tempPositionFilePath);
        if (this.filePositionMap.size() != 0) {
            try {
                FileUtils.write((File)file, (CharSequence)JSONObject.toJSONString(this.filePositionMap), (String)"UTF-8", (boolean)false);
            }
            catch (IOException e) {
                logger.error("Failed writing tempPositionFile", (Throwable)e);
            }
        }
    }

    private void savePositionFile() {
        try {
            ArrayList<KafkaInfo> kafkaInfoList = new ArrayList<KafkaInfo>();
            for (Map.Entry<String, Long> entry : this.positionMap.entrySet()) {
                KafkaInfo kafkaInfo = new KafkaInfo();
                kafkaInfoList.add(kafkaInfo);
                String key = entry.getKey();
                int index = key.lastIndexOf("_");
                kafkaInfo.setTopic(key.substring(0, index));
                kafkaInfo.setPartition(Integer.valueOf(key.substring(index + 1)));
                kafkaInfo.setOffset(entry.getValue());
            }
            String data = JSONArray.toJSONString(kafkaInfoList);
            File positionFile = new File(this.successPositionFilePath);
            FileUtils.write((File)positionFile, (CharSequence)data, (String)"UTF-8", (boolean)false);
        }
        catch (Throwable e) {
            logger.error("Failed writing successPositionFile", e);
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void loadPositionFile(String filePath) {
        block41: {
            try (FileReader fr = new FileReader(filePath);){
                if (fr.ready()) {
                    try (JsonReader jr = new JsonReader((Reader)fr);){
                        jr.beginArray();
                        while (jr.hasNext()) {
                            Integer partition = null;
                            Long offset = null;
                            String topic = null;
                            jr.beginObject();
                            while (jr.hasNext()) {
                                switch (jr.nextName()) {
                                    case "partition": {
                                        partition = jr.nextInt();
                                        break;
                                    }
                                    case "offset": {
                                        offset = jr.nextLong();
                                        break;
                                    }
                                    case "topic": {
                                        topic = jr.nextString();
                                    }
                                }
                            }
                            jr.endObject();
                            for (Object v : Arrays.asList(partition, offset, topic)) {
                                Preconditions.checkNotNull(v, (Object)("Detected missing value in position file. partition: " + partition + ", offset: " + offset + ", topic: " + topic));
                            }
                            String key = topic + "_" + partition;
                            this.positionMap.put(key, offset);
                        }
                        jr.endArray();
                        break block41;
                    }
                }
                logger.warn("File is empty: " + filePath + ", not updating position");
            }
            catch (FileNotFoundException e) {
                logger.info("File not found: " + filePath + ", not updating position");
            }
            catch (Exception e) {
                logger.error("Failed loading positionFile: " + filePath, (Throwable)e);
            }
        }
    }

    private class SavePositionRunnable
    implements Runnable {
        private SavePositionRunnable() {
        }

        @Override
        public void run() {
            KafkaSuccessPositionWriter.this.savePositionFile();
        }
    }

    private class PositionWriterRunnable
    implements Runnable {
        private PositionWriterRunnable() {
        }

        @Override
        public void run() {
            try {
                KafkaSuccessPositionWriter.this.handleCurrentPosition();
            }
            catch (Throwable t) {
                logger.error("\u66f4\u65b0position\u5931\u8d25\uff01", t);
            }
        }
    }
}

