/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.IOError;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;
import org.mapdb.SerializerPojo;

public class EngineWrapper
implements Engine {
    private Engine engine;
    public static final Engine CLOSED = new Engine(){

        @Override
        public long preallocate() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public void preallocate(long[] recids) {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public void close() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public boolean isClosed() {
            return true;
        }

        @Override
        public void commit() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public void rollback() throws UnsupportedOperationException {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public boolean isReadOnly() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public boolean canRollback() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public void clearCache() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public void compact() {
            throw new IllegalAccessError("already closed");
        }

        @Override
        public SerializerPojo getSerializerPojo() {
            throw new IllegalAccessError("already closed");
        }
    };

    protected EngineWrapper(Engine engine) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
    }

    @Override
    public long preallocate() {
        return this.getWrappedEngine().preallocate();
    }

    @Override
    public void preallocate(long[] recids) {
        this.getWrappedEngine().preallocate(recids);
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        return this.getWrappedEngine().put(value, serializer);
    }

    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        return this.getWrappedEngine().get(recid, serializer);
    }

    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        this.getWrappedEngine().update(recid, value, serializer);
    }

    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        return this.getWrappedEngine().compareAndSwap(recid, expectedOldValue, newValue, serializer);
    }

    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        this.getWrappedEngine().delete(recid, serializer);
    }

    @Override
    public void close() {
        Engine e = this.engine;
        if (e != null) {
            e.close();
        }
        this.engine = CLOSED;
    }

    @Override
    public boolean isClosed() {
        return this.engine == CLOSED || this.engine == null;
    }

    @Override
    public void commit() {
        this.getWrappedEngine().commit();
    }

    @Override
    public void rollback() {
        this.getWrappedEngine().rollback();
    }

    @Override
    public boolean isReadOnly() {
        return this.getWrappedEngine().isReadOnly();
    }

    @Override
    public boolean canRollback() {
        return this.getWrappedEngine().canRollback();
    }

    @Override
    public void clearCache() {
        this.getWrappedEngine().clearCache();
    }

    @Override
    public void compact() {
        this.getWrappedEngine().compact();
    }

    @Override
    public SerializerPojo getSerializerPojo() {
        return this.getWrappedEngine().getSerializerPojo();
    }

    public Engine getWrappedEngine() {
        return EngineWrapper.checkClosed(this.engine);
    }

    protected static <V> V checkClosed(V v) {
        if (v == null) {
            throw new IllegalAccessError("DB has been closed");
        }
        return v;
    }

    public static class SerializerCheckEngineWrapper
    extends EngineWrapper {
        protected LongMap<Serializer> recid2serializer = new LongConcurrentHashMap<Serializer>();

        protected SerializerCheckEngineWrapper(Engine engine) {
            super(engine);
        }

        protected synchronized <A> void checkSerializer(long recid, Serializer<A> serializer) {
            Serializer other = this.recid2serializer.get(recid);
            if (other != null) {
                if (other != serializer && other.getClass() != serializer.getClass()) {
                    throw new IllegalArgumentException("Serializer does not match. \n found: " + serializer + " \n expected: " + other);
                }
            } else {
                this.recid2serializer.put(recid, serializer);
            }
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            this.checkSerializer(recid, serializer);
            return super.get(recid, serializer);
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            this.checkSerializer(recid, serializer);
            super.update(recid, value, serializer);
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            this.checkSerializer(recid, serializer);
            return super.compareAndSwap(recid, expectedOldValue, newValue, serializer);
        }

        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            this.checkSerializer(recid, serializer);
            this.recid2serializer.remove(recid);
            super.delete(recid, serializer);
        }
    }

    public static class SynchronizedEngineWrapper
    extends EngineWrapper {
        protected SynchronizedEngineWrapper(Engine engine) {
            super(engine);
        }

        @Override
        public synchronized long preallocate() {
            return super.preallocate();
        }

        @Override
        public synchronized void preallocate(long[] recids) {
            super.preallocate(recids);
        }

        @Override
        public synchronized <A> long put(A value, Serializer<A> serializer) {
            return super.put(value, serializer);
        }

        @Override
        public synchronized <A> A get(long recid, Serializer<A> serializer) {
            return super.get(recid, serializer);
        }

        @Override
        public synchronized <A> void update(long recid, A value, Serializer<A> serializer) {
            super.update(recid, value, serializer);
        }

        @Override
        public synchronized <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            return super.compareAndSwap(recid, expectedOldValue, newValue, serializer);
        }

        @Override
        public synchronized <A> void delete(long recid, Serializer<A> serializer) {
            super.delete(recid, serializer);
        }

        @Override
        public synchronized void close() {
            super.close();
        }

        @Override
        public synchronized boolean isClosed() {
            return super.isClosed();
        }

        @Override
        public synchronized void commit() {
            super.commit();
        }

        @Override
        public synchronized void rollback() {
            super.rollback();
        }

        @Override
        public synchronized boolean isReadOnly() {
            return super.isReadOnly();
        }

        @Override
        public synchronized void compact() {
            super.compact();
        }
    }

    public static class ImmutabilityCheckEngine
    extends EngineWrapper {
        protected LongConcurrentHashMap<Item> items = new LongConcurrentHashMap();

        protected ImmutabilityCheckEngine(Engine engine) {
            super(engine);
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            A ret;
            Item item = this.items.get(recid);
            if (item != null) {
                item.check();
            }
            if ((ret = super.get(recid, serializer)) != null) {
                this.items.put(recid, new Item(serializer, ret));
            }
            return ret;
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            long ret = super.put(value, serializer);
            if (value != null) {
                this.items.put(ret, new Item(serializer, value));
            }
            return ret;
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            Item item = this.items.get(recid);
            if (item != null) {
                item.check();
            }
            super.update(recid, value, serializer);
            if (value != null) {
                this.items.put(recid, new Item(serializer, value));
            }
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            boolean ret;
            Item item = this.items.get(recid);
            if (item != null) {
                item.check();
            }
            if ((ret = super.compareAndSwap(recid, expectedOldValue, newValue, serializer)) && newValue != null) {
                this.items.put(recid, new Item(serializer, item));
            }
            return ret;
        }

        @Override
        public void close() {
            super.close();
            Iterator<Item> iter = this.items.valuesIterator();
            while (iter.hasNext()) {
                iter.next().check();
            }
            this.items.clear();
        }

        protected static class Item {
            final Serializer serializer;
            final Object item;
            final int oldChecksum;

            public Item(Serializer serializer, Object item) {
                if (item == null || serializer == null) {
                    throw new AssertionError((Object)"null");
                }
                this.serializer = serializer;
                this.item = item;
                this.oldChecksum = this.checksum();
                if (this.oldChecksum != this.checksum()) {
                    throw new AssertionError((Object)"inconsistent serialization");
                }
            }

            private int checksum() {
                try {
                    DataOutput2 out = new DataOutput2();
                    this.serializer.serialize(out, this.item);
                    byte[] bb = out.copyBytes();
                    return Arrays.hashCode(bb);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }

            void check() {
                int newChecksum = this.checksum();
                if (this.oldChecksum != newChecksum) {
                    throw new AssertionError((Object)("Record instance was modified: \n  " + this.item + "\n  " + this.serializer));
                }
            }
        }
    }

    public static class DebugEngine
    extends EngineWrapper {
        final Queue<Record> records = new ConcurrentLinkedQueue<Record>();

        public DebugEngine(Engine engine) {
            super(engine);
        }

        @Override
        public long preallocate() {
            long recid = super.preallocate();
            this.records.add(new Record(recid, "PREALLOC"));
            return recid;
        }

        @Override
        public void preallocate(long[] recids) {
            super.preallocate(recids);
            for (long recid : recids) {
                this.records.add(new Record(recid, "PREALLOC"));
            }
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            long recid = super.put(value, serializer);
            this.records.add(new Record(recid, "INSERT \n  val:" + value + "\n  ser:" + serializer));
            return recid;
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            A ret = super.get(recid, serializer);
            this.records.add(new Record(recid, "GET \n  val:" + ret + "\n  ser:" + serializer));
            return ret;
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            super.update(recid, value, serializer);
            this.records.add(new Record(recid, "UPDATE \n  val:" + value + "\n  ser:" + serializer));
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            boolean ret = super.compareAndSwap(recid, expectedOldValue, newValue, serializer);
            this.records.add(new Record(recid, "CAS " + ret + "\n  newVal:" + newValue + "\n  ser:" + serializer));
            return ret;
        }

        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            super.delete(recid, serializer);
            this.records.add(new Record(recid, "DEL"));
        }

        protected static final class Record {
            final long recid;
            final String desc;

            public Record(long recid, String desc) {
                this.recid = recid;
                this.desc = desc;
            }
        }
    }

    public static class ReadOnlyEngine
    extends EngineWrapper {
        public ReadOnlyEngine(Engine engine) {
            super(engine);
        }

        @Override
        public long preallocate() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void preallocate(long[] recids) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void commit() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void rollback() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }
}

