/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.logbus.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configure {
    private static final Logger logger = LoggerFactory.getLogger(Configure.class);
    private final String numThreadString = System.getenv("TGA_THREAD");
    private int numThread;
    private final String appIds = System.getenv("TGA_APPID");
    private List<String> appIdList;
    private List<String> sourceList;
    private HashMap<String, List<String>> channelMap;
    private HashMap<String, List<String>> sinkMap;
    private static volatile Configure configure;

    public int getNumThread() {
        if (this.numThread != 0) {
            return this.numThread;
        }
        if (StringUtils.isNotBlank((String)this.numThreadString)) {
            this.numThread = Integer.parseInt(this.numThreadString);
        }
        return this.numThread;
    }

    public List<String> getAppIdList() {
        if (this.appIdList == null) {
            this.appIdList = StringUtils.isBlank((String)this.appIds) ? new ArrayList<String>() : Arrays.stream(this.appIds.trim().split(",")).map(String::trim).collect(Collectors.toList());
        }
        return this.appIdList;
    }

    public List<String> getSourceList() {
        if (this.sourceList == null) {
            ArrayList<String> list = new ArrayList<String>();
            List<String> appIdList = this.getAppIdList();
            if (appIdList != null) {
                for (String appId : appIdList) {
                    list.add("r_" + appId);
                }
            }
            this.sourceList = list;
        }
        return this.sourceList;
    }

    public HashMap<String, List<String>> getChannelMap() {
        if (this.channelMap == null) {
            HashMap<String, List> map = new HashMap<String, List>();
            for (String appId : this.getAppIdList()) {
                List list = map.computeIfAbsent("r_" + appId, k -> new ArrayList());
                for (int i = 0; i < this.getNumThread(); ++i) {
                    list.add("c_" + appId + "_" + i);
                }
            }
            this.channelMap = map;
        }
        return this.channelMap;
    }

    public HashMap<String, List<String>> getSinkMap() {
        if (this.sinkMap == null) {
            HashMap<String, List> map = new HashMap<String, List>();
            for (String appId : this.getAppIdList()) {
                List list = map.computeIfAbsent("r_" + appId, k -> new ArrayList());
                for (int i = 0; i < this.getNumThread(); ++i) {
                    list.add("s_" + appId + "_" + i);
                }
            }
            this.sinkMap = map;
        }
        return this.sinkMap;
    }

    public static Configure getConfigure() {
        return configure;
    }

    private Configure() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configure getInstance() {
        if (configure != null) return configure;
        Class<Configure> clazz = Configure.class;
        synchronized (Configure.class) {
            if (configure != null) return configure;
            configure = new Configure();
            // ** MonitorExit[var0] (shouldn't be in output)
            return configure;
        }
    }
}

