/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.logbus.utils;

import cn.thinkingdata.ta.logbus.config.FlumeComponentState;
import cn.thinkingdata.ta.logbus.config.TaLogBusContents;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonLock {
    private static final Logger logger = LoggerFactory.getLogger(CommonLock.class);
    static HashSet<String> counter = new HashSet();
    static HashSet<String> resetCounter = new HashSet();
    static boolean resetFlag = true;

    public static boolean checkStateFile() {
        boolean flag = true;
        try {
            String jsonStr = null;
            try {
                File file = new File(TaLogBusContents.LOCK_FILE);
                jsonStr = FileUtils.readFileToString((File)file, (String)"UTF-8");
            }
            catch (IOException e) {
                logger.error("state.lock with exception ", (Throwable)e);
            }
            HashMap stateMap = (HashMap)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<HashMap<String, String>>(){}, (Feature[])new Feature[0]);
            if (stateMap == null) {
                return true;
            }
            String componentFlag = (String)stateMap.get("component");
            flag = FlumeComponentState.RUNNING.getValue().equals(componentFlag);
        }
        catch (Exception e) {
            logger.info("check state File with exception", (Throwable)e);
        }
        return !flag;
    }

    public static synchronized void recordStartCounter(String name) {
        if (!counter.contains(name)) {
            counter.add(name);
            logger.info("== " + name + " Started! Set Json : " + JSON.toJSONString(counter) + " ==");
        }
    }

    public static synchronized void recordStopCounter(String name) {
        if (counter.contains(name)) {
            counter.remove(name);
            logger.info("== " + name + " ready to stop! Set Json : " + JSON.toJSONString(counter) + " ==");
        }
        if (counter.size() == 0) {
            HashMap<String, String> status = new HashMap<String, String>(1);
            status.put("component", FlumeComponentState.READYTOSTOP.getValue());
            File lockF = new File(TaLogBusContents.LOCK_FILE);
            String jsonStr = JSON.toJSONString(status);
            try {
                FileUtils.write((File)lockF, (CharSequence)jsonStr, (String)"UTF-8", (boolean)false);
            }
            catch (IOException e) {
                logger.error("state.lock with exception ", (Throwable)e);
            }
        }
    }

    public static synchronized void recordStartResetCounter(String name) {
        if (!resetCounter.contains(name)) {
            resetCounter.add(name);
            logger.info("== " + name + " Started! ResetSet Json : " + JSON.toJSONString(counter) + " ==");
        }
    }

    public static synchronized boolean recordStopResetCounter(String name) {
        if (resetCounter.contains(name)) {
            resetCounter.remove(name);
            logger.info("== " + name + "ready to stop! ResetSet Json : " + JSON.toJSONString(resetCounter) + " ==");
        }
        if (resetCounter.size() == 0 && resetFlag) {
            String cmd = System.getProperty("user.dir") + "/../../bin/logbus reset_file_channel";
            String[] command = new String[]{"/bin/sh", "-c", cmd};
            File resetFlagFile = new File(TaLogBusContents.TGA_FLUME_LIB_DIR + "conf/reset.flag");
            if (resetFlagFile.exists()) {
                try {
                    FileUtils.forceDelete((File)resetFlagFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                Runtime.getRuntime().exec(command);
            }
            catch (IOException e) {
                logger.error("\u6267\u884c\u91cd\u7f6efile channel\u547d\u4ee4\u5931\u8d25\uff01", (Throwable)e);
                return false;
            }
            logger.info("\u5df2\u91cd\u7f6efile channel");
            resetFlag = false;
        }
        return true;
    }
}

