/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.logbus.utils;

import cn.thinkingdata.ta.logbus.config.TaLogBusContents;
import com.alibaba.fastjson.JSONArray;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtil.class);
    private static final Random random = new Random();

    public static String getContentFromResFile(String filePath) throws IOException {
        String line;
        InputStream resourceAsStream = CommonUtil.class.getResourceAsStream(filePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        reader.close();
        return sb.toString();
    }

    public static String getContentFromFile(String filePath) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        reader.close();
        return sb.toString();
    }

    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String fixFilePattern(String file) {
        String filePattern = file;
        filePattern = filePattern.replaceAll("\\*", ".*");
        filePattern = filePattern.replaceAll("\\.\\.", ".");
        return filePattern;
    }

    public static String getMD5Str(String str) throws Exception {
        return CommonUtil.getHexString(CommonUtil.string2md5(str));
    }

    private static byte[] string2md5(String str) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        return messageDigest.digest(str.getBytes(StandardCharsets.UTF_8));
    }

    public static String getHexString(byte[] tmp) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] str = new char[32];
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            byte byte0 = tmp[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }

    public static void delFile(String fileStr) {
        File file = new File(fileStr);
        if (file.exists()) {
            file.delete();
        }
    }

    public static int hashIndexWithMurmur3(String data, int totalNum) {
        if (data == null) {
            return random.nextInt(totalNum);
        }
        HashCode hashCode = Hashing.murmur3_32().hashBytes(data.getBytes());
        return CommonUtil.toPositive(hashCode.asInt()) % totalNum;
    }

    private static int toPositive(int number) {
        return number & Integer.MAX_VALUE;
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            int colon;
            String host = uhe.getMessage();
            if (host != null && (colon = host.indexOf(58)) > 0) {
                return host.substring(0, colon);
            }
            return "UnknownHost";
        }
    }

    public static String getIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            int colon;
            String host = uhe.getMessage();
            if (host != null && (colon = host.indexOf(58)) > 0) {
                return host.substring(0, colon);
            }
            return "UnknownIP";
        }
    }

    public static Map<String, Long> loadPositionFile(String filePath) {
        HashMap<String, Long> pathPositionMap = new HashMap<String, Long>();
        try {
            String content = FileUtils.readFileToString((File)new File(filePath), (Charset)StandardCharsets.UTF_8);
            List list = JSONArray.parseArray((String)content, Position.class);
            list.forEach(position -> pathPositionMap.put(position.file, position.pos));
        }
        catch (FileNotFoundException e) {
            logger.info("File not found: " + filePath + ", not updating position");
        }
        catch (Exception e) {
            logger.error("Failed loading positionFile: " + filePath, (Throwable)e);
        }
        return pathPositionMap;
    }

    public static void savePositionFile(String filePath, Map<String, Long> pathPositionMap) throws IOException {
        ArrayList<Position> list = new ArrayList<Position>(pathPositionMap.size());
        for (Map.Entry<String, Long> entry : pathPositionMap.entrySet()) {
            Position position = new Position();
            position.file = entry.getKey();
            position.pos = entry.getValue();
            list.add(position);
        }
        String data = JSONArray.toJSONString(list);
        File positionFile = new File(filePath);
        FileUtils.write((File)positionFile, (CharSequence)data, (String)"UTF-8");
    }

    public static boolean getResetFlagByFile() {
        try {
            File resetFlagFile = new File(TaLogBusContents.TGA_FLUME_LIB_DIR + "conf/reset.flag");
            if (resetFlagFile.exists()) {
                String resetFlag = FileUtils.readFileToString((File)resetFlagFile, (Charset)StandardCharsets.UTF_8);
                return Boolean.parseBoolean(resetFlag);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static long getInode(File file) throws IOException {
        return (Long)Files.getAttribute(file.toPath(), "unix:ino", new LinkOption[0]);
    }

    public static long getDev(File file) throws IOException {
        return (Long)Files.getAttribute(file.toPath(), "unix:dev", new LinkOption[0]);
    }

    private static class Position {
        String file;
        Long pos;

        private Position() {
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public Long getPos() {
            return this.pos;
        }

        public void setPos(Long pos) {
            this.pos = pos;
        }
    }
}

