/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.logbus.utils;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class ExtClasspathLoader {
    private static final Method addURL = ExtClasspathLoader.initAddMethod();
    private static final URLClassLoader classloader = (URLClassLoader)ClassLoader.getSystemClassLoader();

    private static Method initAddMethod() {
        try {
            Method add = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            add.setAccessible(true);
            return add;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadClasspath(String path) {
        File file = new File(path);
        ExtClasspathLoader.loopFiles(file);
    }

    private static void loopFiles(File file) {
        if (file.isDirectory()) {
            File[] tmps = file.listFiles();
            if (tmps != null) {
                for (File tmp : tmps) {
                    ExtClasspathLoader.loopFiles(tmp);
                }
            }
        } else if (file.getAbsolutePath().endsWith(".jar") || file.getAbsolutePath().endsWith(".zip")) {
            ExtClasspathLoader.addURL(file);
        }
    }

    private static void addURL(File file) {
        try {
            addURL.invoke((Object)classloader, file.toURI().toURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

