/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.logbus.utils;

import cn.thinkingdata.ta.logbus.matcher.DateMatcher;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    private static final FileSystem FS = FileSystems.getDefault();

    public static void forceDelete(String path) {
        File file = new File(path);
        FileUtil.forceDelete(file);
    }

    public static void forceDelete(File file) {
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            logger.error("\u5220\u9664\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    public static void unzip(Path filePath, final Path destination) throws IOException {
        HashMap<String, String> zipProperties = new HashMap<String, String>();
        zipProperties.put("create", "false");
        zipProperties.put("encoding", "UTF-8");
        URI zipFile = URI.create("jar:file:" + filePath.toUri().getPath());
        FileSystem zipfs = FileSystems.newFileSystem(zipFile, zipProperties);
        final Path rootPath = zipfs.getPath("/", new String[0]);
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetPath = destination.resolve(rootPath.relativize(dir).toString());
                if (!Files.exists(targetPath, new LinkOption[0])) {
                    Files.createDirectory(targetPath, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, destination.resolve(rootPath.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return FileVisitResult.CONTINUE;
            }
        });
        zipfs.close();
    }

    public static void setAsExecutable(String filePath) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(Paths.get(filePath, new String[0]), perms);
    }

    public static void backUpFolder(String tempTarget, List<String> processDir) throws IOException {
        for (String dir : processDir) {
            FileUtils.copyDirectoryToDirectory((File)new File(dir), (File)new File(tempTarget));
            FileUtils.cleanDirectory((File)new File(dir));
        }
    }

    public static void replaceFolder(String source, String destination) throws IOException {
        if (!new File(source).exists()) {
            return;
        }
        final Path sourcePath = Paths.get(source, new String[0]);
        final Path destPath = Paths.get(destination, new String[0]);
        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetPath = destPath.resolve(sourcePath.relativize(dir).toString());
                if (!Files.exists(targetPath, new LinkOption[0])) {
                    Files.createDirectory(targetPath, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, destPath.resolve(sourcePath.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static List<File> analysisRegexPath(String path, String matcher) {
        logger.info(path);
        File file = new File(path);
        File parentFile = file.getParentFile();
        ArrayList regexMatchFiles = Lists.newArrayList();
        if (parentFile != null) {
            if ("regex".equals(matcher)) {
                if (parentFile.isDirectory()) {
                    regexMatchFiles.add(file);
                    return regexMatchFiles;
                }
                StringBuilder fileNameRegex = new StringBuilder();
                while (!parentFile.isDirectory()) {
                    fileNameRegex.insert(0, file.getName() + File.separator);
                    file = parentFile;
                    if ((parentFile = file.getParentFile()) != null) continue;
                    logger.error("\u8def\u5f84\u9519\u8bef\uff1a" + path);
                    return new ArrayList<File>();
                }
                String lastDirectoryRegex = file.getName();
                PathMatcher lastDirectoryMatcher = lastDirectoryRegex.startsWith("DATE{") && lastDirectoryRegex.endsWith("}") ? new DateMatcher(lastDirectoryRegex.substring("DATE{".length(), lastDirectoryRegex.indexOf("}"))) : FS.getPathMatcher("regex:" + lastDirectoryRegex);
                DirectoryStream.Filter<Path> lastDirectoryFilter = filePath -> lastDirectoryMatcher.matches(filePath.getFileName()) && Files.isDirectory(filePath, new LinkOption[0]);
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(parentFile.toPath(), lastDirectoryFilter);){
                    for (Path entry : stream) {
                        File e = new File(entry.toString() + File.separator + fileNameRegex);
                        if (!e.getParentFile().exists()) continue;
                        regexMatchFiles.add(e);
                    }
                }
                catch (IOException e) {
                    logger.error("\u76ee\u5f55\u5b58\u5728\u7f3a\u5931\uff1a" + path, (Throwable)e);
                }
            } else {
                String[] filePaths;
                if (!path.contains("*")) {
                    regexMatchFiles.add(new File(path));
                    return regexMatchFiles;
                }
                for (String filePath2 : filePaths = FileUtil.getFilePathList(path)) {
                    regexMatchFiles.add(new File(filePath2));
                }
            }
        }
        logger.info(path + " \u89e3\u6790\u51fa\u7684\u6587\u4ef6\u6570\u91cf:" + regexMatchFiles.size());
        return regexMatchFiles;
    }

    public static String[] getFilePathList(String filePattern) {
        String token;
        String regex = "/";
        String[] tokens = filePattern.split(regex, -1);
        StringBuilder baseDirBd = new StringBuilder();
        int index = -1;
        while (index < tokens.length - 1 && !(token = tokens[++index]).contains("*") && index != tokens.length - 1) {
            baseDirBd.append(token).append(regex);
        }
        String baseDir = baseDirBd.toString();
        if (baseDir.equals("")) {
            baseDir = "./";
        }
        StringBuilder patternBd = new StringBuilder();
        for (int i = index; i < tokens.length; ++i) {
            patternBd.append(tokens[i]).append("/");
        }
        String pattern = patternBd.substring(0, patternBd.length() - 1);
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        scanner.setIncludes(new String[]{pattern});
        try {
            scanner.scan();
        }
        catch (IllegalStateException e) {
            logger.error("\u901a\u914d\u7b26\u5339\u914d\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            return new String[0];
        }
        String[] includedFiles = scanner.getIncludedFiles();
        String[] result = new String[includedFiles.length];
        for (int i = 0; i < includedFiles.length; ++i) {
            result[i] = baseDir + includedFiles[i];
        }
        return result;
    }
}

