/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.logbus.utils;

import cn.thinkingdata.ta.logbus.config.Configure;
import cn.thinkingdata.ta.logbus.config.TaLogBusContents;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.instrumentation.util.JMXPollUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlumeUtils {
    private static final Logger logger = LoggerFactory.getLogger(FlumeUtils.class);
    private static Boolean CLOSE_FLAG = false;

    public static List<String> getChannelNameListBySourceName(String sourceName) {
        Configure logBusConf = Configure.getInstance();
        if (!sourceName.startsWith("r_")) {
            int threadCount = logBusConf.getNumThread();
            ArrayList<String> channels = new ArrayList<String>();
            int base = (Integer.parseInt(sourceName.substring(1)) - 1) * threadCount;
            for (int j = 0; j < threadCount; ++j) {
                channels.add("c" + (base + j));
            }
            return channels;
        }
        return logBusConf.getChannelMap().get(sourceName);
    }

    public static boolean whetherNeedChannelBalance(String sourceName) {
        Map metricsMap = JMXPollUtil.getAllMBeans();
        boolean singleChannelOverflowFlag = false;
        double maxPercentage = 15.0;
        double totalMaxPercentage = 45.0;
        double totalPercentage = 0.0;
        List<String> channelNames = FlumeUtils.getChannelNameListBySourceName(sourceName);
        for (String channel : channelNames) {
            Map channelMap = (Map)metricsMap.get("CHANNEL." + channel);
            double channelPercentage = Double.parseDouble((String)channelMap.get("ChannelFillPercentage"));
            totalPercentage += channelPercentage;
            if (!(channelPercentage > maxPercentage)) continue;
            singleChannelOverflowFlag = true;
        }
        if (totalPercentage > totalMaxPercentage) {
            singleChannelOverflowFlag = true;
        }
        return singleChannelOverflowFlag;
    }

    public static StringBuilder getChannelConsumerInfo(String sourceName) {
        Map metricsMap = JMXPollUtil.getAllMBeans();
        double totalPercentage = 0.0;
        List<String> channelNames = FlumeUtils.getChannelNameListBySourceName(sourceName);
        StringBuilder stringBuilder = new StringBuilder(sourceName + " \u6d88\u8d39\u6bd4\u4f8b\u7edf\u8ba1\u5f00\u59cb:\n");
        for (String channel : channelNames) {
            Map channelMap = (Map)metricsMap.get("CHANNEL." + channel);
            String channelFillPercentage = (String)channelMap.get("ChannelFillPercentage");
            if (StringUtils.isEmpty((String)channelFillPercentage)) continue;
            double channelPercentage = Double.parseDouble(channelFillPercentage);
            totalPercentage += channelPercentage;
            stringBuilder.append("Channel:").append(channel).append(" \u672a\u6d88\u8d39\u6bd4\u4f8b\uff1a").append(channelPercentage).append("%\n");
        }
        stringBuilder.append("Source:").append(sourceName).append(" \u672a\u6d88\u8d39\u6bd4\u4f8b\uff1a").append(totalPercentage).append("%\n");
        stringBuilder.append(sourceName).append(" \u6d88\u8d39\u6bd4\u4f8b\u7edf\u8ba1\u7ed3\u675f!");
        return stringBuilder;
    }

    public static double getChannelFillPercentageByName(String channelName) {
        Map metricsMap = JMXPollUtil.getAllMBeans();
        Map channelMap = (Map)metricsMap.get("CHANNEL." + channelName);
        return Double.parseDouble((String)channelMap.get("ChannelFillPercentage"));
    }

    public static String getSourceName(String appId) {
        return "r_" + appId;
    }

    public static String getChannelName(String appId, int no) {
        return "c_" + appId + "_" + no;
    }

    public static String getSinkName(String appId, int no) {
        return "s_" + appId + "_" + no;
    }

    public static String getAppIdFromSourceName(String sourceName) {
        return sourceName.split("_")[1];
    }

    public static String getFlumePid() {
        File flumePidFile = new File(TaLogBusContents.FLUME_PID_FILE);
        if (!flumePidFile.exists()) {
            logger.error(TaLogBusContents.FLUME_PID_FILE + "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        try {
            return FileUtils.readFileToString((File)flumePidFile, (String)"UTF-8").replaceAll("[\\t\\n\\r]", "");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6flume.pid\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
    }

    public static void stopFlume() {
        if (CLOSE_FLAG.booleanValue()) {
            return;
        }
        logger.info("\u6267\u884c\u5173\u95edflume\u547d\u4ee4");
        CLOSE_FLAG = true;
        String cmd = System.getProperty("user.dir") + "/../../bin/logbus stop_flume";
        String[] command = new String[]{"/bin/sh", "-c", cmd};
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            logger.error("\u91cd\u542flogbus\u5931\u8d25\uff01", (Throwable)e);
            CLOSE_FLAG = false;
        }
    }
}

