/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.logbus.utils;

import cn.thinkingdata.ta.logbus.utils.CommonUtil;
import cn.thinkingdata.ta.logbus.utils.LoggerUtil;
import cn.thinkingdata.ta.logbus.utils.ProgressBar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestUtil.class);
    private static PoolingHttpClientConnectionManager cm;
    private static SSLContext ctx;
    private static SSLConnectionSocketFactory socketFactory;
    private static RequestConfig requestConfig;
    private static Registry<ConnectionSocketFactory> socketFactoryRegistry;
    private static X509TrustManager xtm;

    public static CloseableHttpClient getConnection() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).build();
    }

    public static void closeHttpClient() throws IOException {
        HttpRequestUtil.getConnection().close();
        cm.close();
    }

    public static String httpGet(String url) throws Exception {
        HttpGet request = new HttpGet(url);
        return HttpRequestUtil.execute((HttpRequestBase)request);
    }

    public static String httpGet(String url, Header[] headers) throws Exception {
        HttpGet request = new HttpGet(url);
        request.setHeaders(headers);
        return HttpRequestUtil.execute((HttpRequestBase)request);
    }

    public static String httpPost(String url) throws Exception {
        HttpPost request = new HttpPost(url);
        return HttpRequestUtil.execute((HttpRequestBase)request);
    }

    public static String httpPost(String url, Header[] headers) throws Exception {
        HttpPost request = new HttpPost(url);
        request.setHeaders(headers);
        return HttpRequestUtil.execute((HttpRequestBase)request);
    }

    public static String httpPost(String url, HttpEntity entity) throws Exception {
        HttpPost request = new HttpPost(url);
        request.setEntity(entity);
        return HttpRequestUtil.execute((HttpRequestBase)request);
    }

    public static String httpPost(String url, Header[] headers, HttpEntity entity) throws Exception {
        HttpPost request = new HttpPost(url);
        request.setHeaders(headers);
        request.setEntity(entity);
        return HttpRequestUtil.execute((HttpRequestBase)request);
    }

    /*
     * Loose catch block
     */
    public static String execute(HttpRequestBase requestBase) throws Exception {
        CloseableHttpClient httpClient = HttpRequestUtil.getConnection();
        try {
            try (CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)requestBase);){
                HttpEntity entity = closeableHttpResponse.getEntity();
                if (entity != null) {
                    entity = new BufferedHttpEntity(entity);
                    String string = EntityUtils.toString((HttpEntity)entity);
                    return string;
                }
                String string = null;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            requestBase.abort();
        }
    }

    public static void downLoad(String remoteUrl, String remoteFileName, String localFileName) throws Exception {
        String url = remoteUrl + remoteFileName;
        HttpGet httpget = new HttpGet(url);
        logger.info("\u4e0b\u8f7d\u5730\u5740\uff1a" + url);
        CloseableHttpClient httpClient = HttpRequestUtil.getConnection();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        ProgressBar progressBar = new ProgressBar();
        OutputStream out = null;
        InputStream in = null;
        try {
            int readLength;
            File file;
            HttpEntity responseEntity = response.getEntity();
            in = responseEntity.getContent();
            long length = responseEntity.getContentLength();
            double downSize = 0.0;
            if (length <= 0L) {
                logger.error("== \u4e2d\u592e\u4ed3\u5e93logBus\u5b89\u88c5\u5305\u4e0d\u5b58\u5728 ==");
                LoggerUtil.error("== \u4e2d\u592e\u4ed3\u5e93logBus\u5b89\u88c5\u5305\u4e0d\u5b58\u5728 ==");
                throw new IOException("== \u4e2d\u592e\u4ed3\u5e93logBus\u5b89\u88c5\u5305\u4e0d\u5b58\u5728 ==");
            }
            Integer statusCode = response.getStatusLine().getStatusCode();
            if (!statusCode.equals(200)) {
                logger.error("== \u4e0b\u8f7dlogbus\u6587\u4ef6\u5931\u8d25,\u4e0e\u4e2d\u592e\u4ed3\u5e93\u5e94\u7b54\u5f02\u5e38\u3002 ==");
                LoggerUtil.error("== \u4e0b\u8f7dlogbus\u6587\u4ef6\u5931\u8d25,\u4e0e\u4e2d\u592e\u4ed3\u5e93\u5e94\u7b54\u5f02\u5e38 ==");
                throw new Exception("\u4e0b\u8f7dlogbus\u6587\u4ef6\u5931\u8d25,\u4e0e\u4e2d\u592e\u4ed3\u5e93\u5e94\u7b54\u5f02\u5e38:" + statusCode);
            }
            logger.info("\n== logBus \u4e0b\u8f7d\u4e2d ==");
            LoggerUtil.info("\n== logBus \u4e0b\u8f7d\u4e2d ==");
            progressBar.initProgress();
            String localFilePath = localFileName.substring(0, localFileName.lastIndexOf("/"));
            File directories = new File(localFilePath);
            if (!directories.exists()) {
                directories.mkdirs();
            }
            if (!(file = new File(localFileName)).exists()) {
                file.createNewFile();
            }
            out = new FileOutputStream(file);
            byte[] buffer = new byte[4096];
            while ((readLength = in.read(buffer)) > 0) {
                byte[] bytes = new byte[readLength];
                System.arraycopy(buffer, 0, bytes, 0, readLength);
                out.write(bytes);
                progressBar.printProgress(downSize += (double)readLength, length);
            }
            out.flush();
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dlogbus\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + CommonUtil.getStackTraceAsString(e));
            LoggerUtil.error("\u4e0b\u8f7dlogbus\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + CommonUtil.getStackTraceAsString(e));
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("release connection with error:" + e);
                }
            }
        }
    }

    static {
        ctx = null;
        xtm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{xtm}, null);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("SSLContext init with NoSuchAlgorithmException", (Throwable)e);
        }
        catch (KeyManagementException e) {
            logger.error("SSLContext init with KeyManagementException", (Throwable)e);
        }
        socketFactory = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        requestConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setExpectContinueEnabled(Boolean.TRUE.booleanValue()).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).setConnectTimeout(600000).setSocketTimeout(300000).build();
        socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build();
        cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        cm.setDefaultMaxPerRoute(60);
        cm.setMaxTotal(100);
    }
}

