/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.logbus.utils;

public class LoggerUtil {
    private static final String RED_COLOR = "\u001b[01;40;31m";
    private static final String GREEN_COLOR = "\u001b[01;40;32m";
    private static final String YELLOW_COLOR = "\u001b[01;40;33m";
    private static final String RESET = "\u001b[0m";
    private static final String SUCCESS_FLAG = "[\u001b[36m\u221a\u001b[0m]";
    private static final String WARN_FLAG = "[\u001b[33m!\u001b[0m]";
    private static final String FAIL_FLAG = "[\u001b[31m\u00d7\u001b[0m]";
    private static final String RUNNING_TYPE = "shell";

    public static void info(String content) {
        System.out.println(content);
    }

    public static void error(String content) {
        System.err.println(RED_COLOR + content + RESET);
    }

    public static void greenInfo(String content) {
        System.err.println(GREEN_COLOR + content + RESET);
    }

    public static void yellowInfo(String content) {
        System.err.println(YELLOW_COLOR + content + RESET);
    }

    public static void success(String message) {
        LoggerUtil.success(0, message);
    }

    public static void success(int level, String message) {
        StringBuilder front = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            front.append(" ");
        }
        System.out.println(front + SUCCESS_FLAG + message);
    }

    public static void warn(String message) {
        LoggerUtil.warn(0, message);
    }

    public static void warn(int level, String message) {
        StringBuilder front = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            front.append(" ");
        }
        System.out.print(front + WARN_FLAG);
        System.err.println("\u001b[33m" + message + RESET);
    }

    public static void fail(String message) {
        LoggerUtil.fail(0, message);
    }

    public static void fail(int level, String message) {
        StringBuilder front = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            front.append(" ");
        }
        System.out.print(front + FAIL_FLAG);
        System.err.println("\u001b[31m" + message + RESET);
    }
}

