/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.logbus.utils;

import com.google.common.base.Preconditions;

public class ProgressBar {
    private String finish;
    private String unFinish;
    private static final int PROGRESS_SIZE = 100;

    public String repeat(String string, double count) {
        int n;
        Preconditions.checkNotNull((Object)string);
        if (count <= 1.0) {
            Preconditions.checkArgument((count >= 0.0 ? 1 : 0) != 0, (String)"invalid count: %s", (Object)count);
            return count == 0.0 ? "" : string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + longSize);
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public void initProgress() {
        this.unFinish = this.repeat("-", 50.0);
        String target = String.format("%3d%%\u251c%s%s\u2524", 0, "", this.unFinish);
        System.out.print(" Progress:   " + target);
    }

    public void printProgress(double index, double totalSize) throws InterruptedException {
        if (totalSize == 0.0) {
            System.out.print("\u603b\u4efb\u52a1\u4e3a0.");
            return;
        }
        if (index == totalSize) {
            this.finish = this.repeat(">", 50.0);
            String target = String.format("%3d%%\u251c%s%s\u2524", 100, this.finish, "");
            System.out.print("\rProgress:   " + target);
            return;
        }
        this.finish = this.repeat(">", index / totalSize * 100.0 / 2.0);
        this.unFinish = this.repeat("-", 100.0 * (1.0 - index / totalSize) / 2.0);
        String target = String.format("%3d%%\u251c%s%s\u2524", (int)(index / totalSize * 100.0), this.finish, this.unFinish);
        System.out.print("\rProgress:   " + target);
    }
}

