/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.logbus.utils;

import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class UUIDUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static void main(String[] args) throws InterruptedException {
        HashSet set = new HashSet();
        long startTime = System.currentTimeMillis();
        int size = 1000000;
        for (int i = 0; i < 10; ++i) {
            Thread t1 = new Thread(() -> {
                for (int j = 0; j < 100000; ++j) {
                    set.add(UUIDUtils.getUUID());
                }
            });
            t1.start();
            t1.join();
        }
        long endTime = System.currentTimeMillis();
        System.out.println(set.size());
        System.out.println("getUUID\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        HashSet set1 = new HashSet();
        startTime = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            Thread t2 = new Thread(() -> {
                for (int j = 0; j < 100000; ++j) {
                    set1.add(UUIDUtils.getUUIDString());
                }
            });
            t2.start();
            t2.join();
        }
        endTime = System.currentTimeMillis();
        System.out.println(set1.size());
        System.out.println("getUUIDString\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        HashSet set2 = new HashSet();
        startTime = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            Thread t3 = new Thread(() -> {
                for (int j = 0; j < 100000; ++j) {
                    set2.add(UUIDUtils.jdk8ThreadLocalRandomUUId());
                }
            });
            t3.start();
            t3.join();
        }
        endTime = System.currentTimeMillis();
        System.out.println(set2.size());
        System.out.println("jdk8ThreadLocalRandomUUId\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
    }

    public static String jdk8ThreadLocalRandomUUId() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        UUID uuid = new UUID(random.nextInt(), random.nextInt());
        return uuid.toString();
    }

    public static String getUUIDString() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long mostSignificantBits = random.nextLong();
        long leastSignificantBits = random.nextLong();
        char[] uuidChars = new char[]{HEX_DIGITS[(int)((mostSignificantBits & 0xF000000000000000L) >>> 60)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00000000000000L) >>> 56)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0000000000000L) >>> 52)], HEX_DIGITS[(int)((mostSignificantBits & 0xF000000000000L) >>> 48)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00000000000L) >>> 44)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0000000000L) >>> 40)], HEX_DIGITS[(int)((mostSignificantBits & 0xF000000000L) >>> 36)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00000000L) >>> 32)], '-', HEX_DIGITS[(int)((mostSignificantBits & 0xF0000000L) >>> 28)], HEX_DIGITS[(int)((mostSignificantBits & 0xF000000L) >>> 24)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00000L) >>> 20)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0000L) >>> 16)], '-', HEX_DIGITS[(int)((mostSignificantBits & 0xF000L) >>> 12)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00L) >>> 8)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0L) >>> 4)], HEX_DIGITS[(int)(mostSignificantBits & 0xFL)], '-', HEX_DIGITS[(int)((leastSignificantBits & 0xF000000000000000L) >>> 60)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00000000000000L) >>> 56)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0000000000000L) >>> 52)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000000000000L) >>> 48)], '-', HEX_DIGITS[(int)((leastSignificantBits & 0xF00000000000L) >>> 44)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0000000000L) >>> 40)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000000000L) >>> 36)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00000000L) >>> 32)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0000000L) >>> 28)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000000L) >>> 24)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00000L) >>> 20)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0000L) >>> 16)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000L) >>> 12)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00L) >>> 8)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0L) >>> 4)], HEX_DIGITS[(int)(leastSignificantBits & 0xFL)]};
        return new String(uuidChars);
    }

    public static String getUUID() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long lsb = random.nextLong();
        long msb = random.nextLong();
        char[] buf = new char[36];
        UUIDUtils.formatUnsignedLong(lsb, buf, 24, 12);
        buf[8] = 45;
        UUIDUtils.formatUnsignedLong(lsb >>> 48, buf, 19, 4);
        buf[13] = 45;
        UUIDUtils.formatUnsignedLong(msb, buf, 14, 4);
        buf[18] = 45;
        UUIDUtils.formatUnsignedLong(msb >>> 16, buf, 9, 4);
        buf[23] = 45;
        UUIDUtils.formatUnsignedLong(msb >>> 32, buf, 0, 8);
        return new String(buf);
    }

    private static void formatUnsignedLong(long val, char[] buf, int offset, int len) {
        int charPos = offset + len;
        int radix = 16;
        int mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)val & mask];
            val >>>= 4;
        } while (charPos > offset);
    }
}

