/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.customsource.kafka;

import cn.thinkingdata.ta.customsource.kafka.KafkaInfo;
import cn.thinkingdata.ta.customsource.kafka.SourceRebalanceListener;
import cn.thinkingdata.ta.logbus.config.TaLogBusContents;
import cn.thinkingdata.ta.logbus.utils.CommonLock;
import cn.thinkingdata.ta.logbus.utils.CommonUtil;
import cn.thinkingdata.ta.logbus.utils.FlumeUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kafka.cluster.BrokerEndPoint;
import kafka.zk.KafkaZkClient;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.PollableSource;
import org.apache.flume.conf.BatchSizeSupported;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.LogPrivacyUtil;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.instrumentation.kafka.KafkaSourceCounter;
import org.apache.flume.shared.kafka.KafkaSSLUtil;
import org.apache.flume.source.AbstractPollableSource;
import org.apache.flume.source.avro.AvroFlumeEvent;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class KafkaSource
extends AbstractPollableSource
implements Configurable,
BatchSizeSupported {
    private static final Logger log = LoggerFactory.getLogger(KafkaSource.class);
    private static final int ZK_SESSION_TIMEOUT = 30000;
    private static final int ZK_CONNECTION_TIMEOUT = 30000;
    private Context context;
    private Properties kafkaProps;
    private KafkaSourceCounter counter;
    private KafkaConsumer<String, byte[]> consumer;
    private Iterator<ConsumerRecord<String, byte[]>> it;
    private final List<Event> eventList = new ArrayList<Event>();
    private Map<TopicPartition, OffsetAndMetadata> tpAndOffsetMetadata;
    private AtomicBoolean rebalanceFlag;
    private Map<String, String> headers;
    private Optional<SpecificDatumReader<AvroFlumeEvent>> reader = Optional.absent();
    private BinaryDecoder decoder = null;
    private boolean useAvroEventFormat;
    private int batchUpperLimit;
    private int maxBatchDurationMillis;
    private Subscriber subscriber;
    private String zookeeperConnect;
    private String bootstrapServers;
    private String groupId = "flume";
    private int retardInterval = 1000;
    private int maxRetardInterval = 10000;
    private int retardCount = 0;
    private boolean checkStateFlag = false;
    private int stateBalancerInterval = 10000;
    private int stateBalancerInitDelay = 5000;
    private String successOffsetInfoFilePath;
    private boolean resetFlag;
    private final Map<String, Long> startOffsetMap = new HashMap<String, Long>();
    @Deprecated
    private boolean migrateZookeeperOffsets = true;
    private String topicHeader = null;
    private boolean setTopicHeader;

    public long getBatchSize() {
        return this.batchUpperLimit;
    }

    protected PollableSource.Status doProcess() throws EventDeliveryException {
        if (this.checkStateFlag) {
            CommonLock.recordStopCounter((String)this.getName());
            return PollableSource.Status.BACKOFF;
        }
        if (this.resetFlag) {
            try {
                TimeUnit.MILLISECONDS.sleep(10000L);
                log.info("\u91cd\u7f6efile channel\uff0c\u4e0d\u8bfb\u53d6\u6570\u636e");
            }
            catch (InterruptedException e) {
                log.info("Interrupted while sleeping");
            }
            return PollableSource.Status.BACKOFF;
        }
        if (this.successOffsetInfoFilePath != null && this.retardCount > 50) {
            FlumeUtils.stopFlume();
            return PollableSource.Status.BACKOFF;
        }
        try {
            try {
                boolean retardFlag = FlumeUtils.whetherNeedChannelBalance((String)this.getName());
                if (retardFlag) {
                    this.retardInterval <<= 1;
                    this.retardInterval = Math.min(this.retardInterval, this.maxRetardInterval);
                    log.info("Channel \u672a\u6d88\u8d39\u603b\u91cf\u8fc7\u5927 \uff0c" + this.getName() + " \u4f11\u7720 " + this.retardInterval + " ms");
                    TimeUnit.MILLISECONDS.sleep(this.retardInterval);
                    ++this.retardCount;
                    return PollableSource.Status.BACKOFF;
                }
                this.retardInterval = 1000;
                this.retardCount = 0;
            }
            catch (Exception e) {
                log.error("\u7edf\u8ba1\u6d88\u8d39\u901f\u7387\u5931\u8d25\uff01", (Throwable)e);
            }
            long nanoBatchStartTime = System.nanoTime();
            long batchStartTime = System.currentTimeMillis();
            long maxBatchEndTime = System.currentTimeMillis() + (long)this.maxBatchDurationMillis;
            String batchUUID = UUID.randomUUID().toString();
            while (this.eventList.size() < this.batchUpperLimit && System.currentTimeMillis() < maxBatchEndTime) {
                byte[] eventBody;
                if (this.it == null || !this.it.hasNext()) {
                    long durMs = Math.max(0L, maxBatchEndTime - System.currentTimeMillis());
                    Duration duration = Duration.ofMillis(durMs);
                    ConsumerRecords records = this.consumer.poll(duration);
                    this.it = records.iterator();
                    if (this.rebalanceFlag.compareAndSet(true, false)) break;
                    if (!this.it.hasNext()) {
                        this.counter.incrementKafkaEmptyCount();
                        log.debug("Returning with backoff. No more data to read");
                        break;
                    }
                }
                ConsumerRecord<String, byte[]> message = this.it.next();
                String kafkaKey = (String)message.key();
                if (this.useAvroEventFormat) {
                    ByteArrayInputStream in = new ByteArrayInputStream((byte[])message.value());
                    this.decoder = DecoderFactory.get().directBinaryDecoder((InputStream)in, this.decoder);
                    if (!this.reader.isPresent()) {
                        this.reader = Optional.of((Object)new SpecificDatumReader(AvroFlumeEvent.class));
                    }
                    AvroFlumeEvent avroEvent = (AvroFlumeEvent)((SpecificDatumReader)this.reader.get()).read(null, (Decoder)this.decoder);
                    eventBody = avroEvent.getBody().array();
                    this.headers = KafkaSource.toStringMap(avroEvent.getHeaders());
                } else {
                    eventBody = (byte[])message.value();
                    this.headers.clear();
                    this.headers = new HashMap<String, String>(4);
                }
                if (!this.headers.containsKey("timestamp")) {
                    this.headers.put("timestamp", String.valueOf(System.currentTimeMillis()));
                }
                if (this.setTopicHeader && !this.headers.containsKey(this.topicHeader)) {
                    this.headers.put(this.topicHeader, message.topic());
                }
                if (!this.headers.containsKey("partition")) {
                    this.headers.put("partition", String.valueOf(message.partition()));
                }
                if (!this.headers.containsKey("offset")) {
                    this.headers.put("offset", String.valueOf(message.offset()));
                }
                if (kafkaKey != null) {
                    this.headers.put("key", kafkaKey);
                }
                this.headers.put("startOffset", String.valueOf(this.startOffsetMap.get(message.topic() + "_" + message.partition())));
                if (log.isTraceEnabled()) {
                    if (LogPrivacyUtil.allowLogRawData()) {
                        log.trace("Topic: {} Partition: {} Message: {}", new Object[]{message.topic(), message.partition(), new String(eventBody)});
                    } else {
                        log.trace("Topic: {} Partition: {} Message arrived.", (Object)message.topic(), (Object)message.partition());
                    }
                }
                Event event = EventBuilder.withBody((byte[])eventBody, this.headers);
                event.getHeaders().put("sourceName", this.getName());
                this.eventList.add(event);
                if (log.isDebugEnabled()) {
                    log.debug("Waited: {} ", (Object)(System.currentTimeMillis() - batchStartTime));
                    log.debug("Event #: {}", (Object)this.eventList.size());
                }
                this.tpAndOffsetMetadata.put(new TopicPartition(message.topic(), message.partition()), new OffsetAndMetadata(message.offset() + 1L, batchUUID));
                if (!this.checkStateFlag) continue;
                return PollableSource.Status.BACKOFF;
            }
            if (this.eventList.size() > 0) {
                this.counter.addToKafkaEventGetTimer((System.nanoTime() - nanoBatchStartTime) / 1000000L);
                this.counter.addToEventReceivedCount((long)this.eventList.size());
                this.getChannelProcessor().processEventBatch(this.eventList);
                this.counter.addToEventAcceptedCount((long)this.eventList.size());
                if (log.isDebugEnabled()) {
                    log.debug("Wrote {} events to channel", (Object)this.eventList.size());
                }
                this.eventList.clear();
                if (!this.tpAndOffsetMetadata.isEmpty()) {
                    long commitStartTime = System.nanoTime();
                    this.consumer.commitSync(this.tpAndOffsetMetadata);
                    long commitEndTime = System.nanoTime();
                    this.counter.addToKafkaCommitTimer((commitEndTime - commitStartTime) / 1000000L);
                    this.tpAndOffsetMetadata.clear();
                }
                return PollableSource.Status.READY;
            }
            return PollableSource.Status.BACKOFF;
        }
        catch (Exception e) {
            log.error("KafkaSource EXCEPTION", (Throwable)e);
            this.counter.incrementEventReadOrChannelFail((Throwable)e);
            return PollableSource.Status.BACKOFF;
        }
    }

    protected void doConfigure(Context context) throws FlumeException {
        String groupIdProperty;
        this.context = context;
        this.headers = new HashMap<String, String>(4);
        this.tpAndOffsetMetadata = new HashMap<TopicPartition, OffsetAndMetadata>();
        this.rebalanceFlag = new AtomicBoolean(false);
        this.kafkaProps = new Properties();
        this.translateOldProperties(context);
        String topicProperty = context.getString("kafka.topics.regex");
        if (topicProperty != null && !topicProperty.isEmpty()) {
            this.subscriber = new PatternSubscriber(topicProperty);
        } else {
            topicProperty = context.getString("kafka.topics");
            if (topicProperty != null && !topicProperty.isEmpty()) {
                this.subscriber = new TopicListSubscriber(topicProperty);
            } else if (this.subscriber == null) {
                throw new ConfigurationException("At least one Kafka topic must be specified.");
            }
        }
        this.batchUpperLimit = context.getInteger("batchSize", Integer.valueOf(1000));
        this.maxBatchDurationMillis = context.getInteger("batchDurationMillis", Integer.valueOf(1000));
        this.useAvroEventFormat = context.getBoolean("useFlumeEventFormat", Boolean.valueOf(false));
        if (log.isDebugEnabled()) {
            log.debug("useFlumeEventFormat set to: {}", (Object)this.useAvroEventFormat);
        }
        this.zookeeperConnect = context.getString("zookeeperConnect");
        this.migrateZookeeperOffsets = context.getBoolean("migrateZookeeperOffsets", Boolean.valueOf(true));
        this.bootstrapServers = context.getString("kafka.bootstrap.servers");
        if (this.bootstrapServers == null || this.bootstrapServers.isEmpty()) {
            if (this.zookeeperConnect == null || this.zookeeperConnect.isEmpty()) {
                throw new ConfigurationException("Bootstrap Servers must be specified");
            }
            log.warn("{} is deprecated. Please use the parameter {}", (Object)"zookeeperConnect", (Object)"kafka.bootstrap.servers");
            String securityProtocolStr = (String)context.getSubProperties("kafka.consumer.").get((Object)"security.protocol");
            if (securityProtocolStr == null || securityProtocolStr.isEmpty()) {
                securityProtocolStr = "PLAINTEXT";
            }
            this.bootstrapServers = this.lookupBootstrap(this.zookeeperConnect, SecurityProtocol.valueOf((String)securityProtocolStr));
        }
        if ((groupIdProperty = context.getString("kafka.consumer.group.id")) != null && !groupIdProperty.isEmpty()) {
            this.groupId = groupIdProperty;
        }
        if (this.groupId == null || this.groupId.isEmpty()) {
            this.groupId = "flume";
            log.info("Group ID was not specified. Using {} as the group id.", (Object)this.groupId);
        }
        this.setTopicHeader = context.getBoolean("setTopicHeader", Boolean.valueOf(true));
        this.topicHeader = context.getString("topicHeader", "topic");
        this.setConsumerProps(context);
        if (log.isDebugEnabled() && LogPrivacyUtil.allowLogPrintConfig()) {
            log.debug("Kafka consumer properties: {}", (Object)this.kafkaProps);
        }
        if (this.counter == null) {
            this.counter = new KafkaSourceCounter(this.getName());
        }
        this.successOffsetInfoFilePath = context.getString("successPositionFile");
        this.resetFlag = CommonUtil.getResetFlagByFile();
    }

    private void translateOldProperties(Context ctx) {
        String topic = this.context.getString("topic");
        if (topic != null && !topic.isEmpty()) {
            this.subscriber = new TopicListSubscriber(topic);
            log.warn("{} is deprecated. Please use the parameter {}", (Object)"topic", (Object)"kafka.topics");
        }
        this.groupId = ctx.getString("groupId");
        if (this.groupId != null && !this.groupId.isEmpty()) {
            log.warn("{} is deprecated. Please use the parameter {}", (Object)"groupId", (Object)"kafka.consumer.group.id");
        }
    }

    private void setConsumerProps(Context ctx) {
        String jaasConfig;
        String securityProtocol;
        String saslMechanism;
        this.kafkaProps.clear();
        this.kafkaProps.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.kafkaProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        this.kafkaProps.put("max.poll.records", ctx.getInteger("batchSize", Integer.valueOf(1000)));
        this.kafkaProps.put("max.partition.fetch.bytes", (Object)0x300000);
        this.kafkaProps.putAll((Map<?, ?>)ctx.getSubProperties("kafka.consumer."));
        this.kafkaProps.put("bootstrap.servers", this.bootstrapServers);
        if (this.groupId != null) {
            this.kafkaProps.put("group.id", this.groupId);
        }
        this.kafkaProps.put("enable.auto.commit", "false");
        String cloudProvider = ctx.getString("kafka.consumer.cloudProvider", "");
        String instance = ctx.getString("kafka.consumer.instance", "");
        String username = ctx.getString("kafka.consumer.username", "");
        String password = ctx.getString("kafka.consumer.password", "");
        if (StringUtils.isNotBlank((CharSequence)cloudProvider)) {
            switch (cloudProvider) {
                case "tencent": {
                    this.kafkaProps.put("security.protocol", "SASL_PLAINTEXT");
                    this.kafkaProps.put("sasl.mechanism", "PLAIN");
                    String required = "required username=\"" + instance + "#" + username + "\" password=\"" + password + "\";";
                    this.kafkaProps.put("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule " + required);
                    break;
                }
                case "ali": {
                    this.kafkaProps.put("security.protocol", "SASL_SSL");
                    this.kafkaProps.put("sasl.mechanism", "PLAIN");
                    String required = "required username=\"" + username + "\" password=\"" + password + "\";";
                    this.kafkaProps.put("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule " + required);
                    this.kafkaProps.put("ssl.truststore.location", TaLogBusContents.ALI_KAFKA_SSL_TRUSTSTORE_JKS);
                    this.kafkaProps.put("ssl.truststore.password", "KafkaOnsClient");
                    this.kafkaProps.put("ssl.endpoint.identification.algorithm", "");
                    break;
                }
                case "huawei": {
                    this.kafkaProps.put("security.protocol", "SASL_SSL");
                    this.kafkaProps.put("sasl.mechanism", "PLAIN");
                    String required = "required username=\"" + username + "\" password=\"" + password + "\";";
                    this.kafkaProps.put("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule " + required);
                    this.kafkaProps.put("ssl.truststore.location", TaLogBusContents.HUAWEI_KAFKA_SSL_TRUSTSTORE_JKS);
                    this.kafkaProps.put("ssl.truststore.password", "dms@kafka");
                    this.kafkaProps.put("ssl.endpoint.identification.algorithm", "");
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(saslMechanism = ctx.getString("kafka.consumer.sasl.mechanism", "")))) {
            this.kafkaProps.put("sasl.mechanism", saslMechanism);
        }
        if (StringUtils.isNotEmpty((CharSequence)(securityProtocol = ctx.getString("kafka.consumer.security.protocol", "")))) {
            this.kafkaProps.put("security.protocol", securityProtocol);
        }
        if (StringUtils.isNotEmpty((CharSequence)(jaasConfig = ctx.getString("kafka.consumer.jaas.path", "")))) {
            System.setProperty("java.security.auth.login.config", jaasConfig);
        }
        KafkaSSLUtil.addGlobalSSLParameters((Properties)this.kafkaProps);
    }

    private String lookupBootstrap(String zookeeperConnect, SecurityProtocol securityProtocol) {
        try (KafkaZkClient zkClient = KafkaZkClient.apply((String)zookeeperConnect, (boolean)JaasUtils.isZkSecurityEnabled(), (int)30000, (int)30000, (int)10, (Time)Time.SYSTEM, (String)"kafka.server", (String)"SessionExpireListener", (Option)KafkaZkClient.apply$default$9());){
            List brokerList = (List)JavaConverters.seqAsJavaListConverter((Seq)zkClient.getAllBrokersInCluster()).asJava();
            List endPoints = brokerList.stream().map(broker -> broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol))).collect(Collectors.toList());
            ArrayList<String> connections = new ArrayList<String>();
            for (BrokerEndPoint endPoint : endPoints) {
                connections.add(endPoint.connectionString());
            }
            String string = StringUtils.join(connections, (char)',');
            return string;
        }
    }

    @VisibleForTesting
    String getBootstrapServers() {
        return this.bootstrapServers;
    }

    Properties getConsumerProps() {
        return this.kafkaProps;
    }

    private static Map<String, String> toStringMap(Map<CharSequence, CharSequence> charSeqMap) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<CharSequence, CharSequence> entry : charSeqMap.entrySet()) {
            stringMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return stringMap;
    }

    <T> Subscriber<T> getSubscriber() {
        return this.subscriber;
    }

    protected void doStart() throws FlumeException {
        log.info("Starting {}...", (Object)this);
        if (this.migrateZookeeperOffsets && this.zookeeperConnect != null && !this.zookeeperConnect.isEmpty()) {
            if (this.subscriber instanceof TopicListSubscriber && ((TopicListSubscriber)this.subscriber).get().size() == 1) {
                String topicStr = (String)((TopicListSubscriber)this.subscriber).get().get(0);
                this.migrateOffsets(topicStr);
            } else {
                log.info("Will not attempt to migrate offsets because multiple topics or a pattern are defined");
            }
        }
        ScheduledThreadPoolExecutor checkStateFileService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("Kafka-Source-CheckStateFileService-" + this.getName()).daemon(true).build());
        checkStateFileService.scheduleWithFixedDelay(new CheckStateFileRunnable(), 5L, 3L, TimeUnit.SECONDS);
        ScheduledThreadPoolExecutor channelConsumerScheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("Source-StateBalancerScheduledExecutorService-" + this.getName()).setDaemon(true).build());
        channelConsumerScheduledExecutorService.scheduleWithFixedDelay(new ChannelConsumer(), this.stateBalancerInitDelay, this.stateBalancerInterval, TimeUnit.MILLISECONDS);
        ScheduledThreadPoolExecutor consumerInfoStatisticsService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("Source-ConsumerStatisticsService-" + this.getName()).setDaemon(true).build());
        consumerInfoStatisticsService.scheduleWithFixedDelay(new ConsumerStatistics(this.consumer), 5L, 5L, TimeUnit.MINUTES);
        this.consumer = new KafkaConsumer(this.kafkaProps);
        this.subscriber.subscribe(this.consumer, new SourceRebalanceListener(this.rebalanceFlag));
        if (this.subscriber instanceof TopicListSubscriber) {
            this.putStartOffsetMap();
        }
        log.info("Kafka source {} started.", (Object)this.getName());
        this.counter.start();
        CommonLock.recordStartCounter((String)this.getName());
    }

    protected void doStop() throws FlumeException {
        if (this.consumer != null) {
            this.consumer.wakeup();
            this.consumer.close();
        }
        if (this.counter != null) {
            this.counter.stop();
        }
        log.info("Kafka Source {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.counter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void migrateOffsets(String topicStr) {
        try (KafkaZkClient zkClient = KafkaZkClient.apply((String)this.zookeeperConnect, (boolean)JaasUtils.isZkSecurityEnabled(), (int)30000, (int)30000, (int)10, (Time)Time.SYSTEM, (String)"kafka.server", (String)"SessionExpireListener", (Option)KafkaZkClient.apply$default$9());
             KafkaConsumer consumer = new KafkaConsumer(this.kafkaProps);){
            Map<TopicPartition, OffsetAndMetadata> kafkaOffsets = this.getKafkaOffsets((KafkaConsumer<String, byte[]>)consumer, topicStr);
            if (kafkaOffsets == null) {
                log.warn("Topic " + topicStr + " not found in Kafka. Offset migration will be skipped.");
                return;
            }
            if (!kafkaOffsets.isEmpty()) {
                log.info("Found Kafka offsets for topic " + topicStr + ". Will not migrate from zookeeper");
                log.debug("Offsets found: {}", kafkaOffsets);
                return;
            }
            log.info("No Kafka offsets found. Migrating zookeeper offsets");
            Map<TopicPartition, OffsetAndMetadata> zookeeperOffsets = this.getZookeeperOffsets(zkClient, (KafkaConsumer<String, byte[]>)consumer, topicStr);
            if (zookeeperOffsets.isEmpty()) {
                log.warn("No offsets to migrate found in Zookeeper");
                return;
            }
            log.info("Committing Zookeeper offsets to Kafka");
            log.debug("Offsets to commit: {}", zookeeperOffsets);
            consumer.commitSync(zookeeperOffsets);
            Map<TopicPartition, OffsetAndMetadata> newKafkaOffsets = this.getKafkaOffsets((KafkaConsumer<String, byte[]>)consumer, topicStr);
            log.debug("Offsets committed: {}", newKafkaOffsets);
            if (newKafkaOffsets == null) throw new FlumeException("Offsets could not be committed");
            if (newKafkaOffsets.keySet().containsAll(zookeeperOffsets.keySet())) return;
            throw new FlumeException("Offsets could not be committed");
        }
    }

    private Map<TopicPartition, OffsetAndMetadata> getKafkaOffsets(KafkaConsumer<String, byte[]> client, String topicStr) {
        HashMap<TopicPartition, OffsetAndMetadata> offsets = null;
        List partitions = client.partitionsFor(topicStr);
        if (partitions != null) {
            offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            for (PartitionInfo partition : partitions) {
                TopicPartition key = new TopicPartition(topicStr, partition.partition());
                OffsetAndMetadata offsetAndMetadata = client.committed(key);
                if (offsetAndMetadata == null) continue;
                offsets.put(key, offsetAndMetadata);
            }
        }
        return offsets;
    }

    private Map<TopicPartition, OffsetAndMetadata> getZookeeperOffsets(KafkaZkClient zkClient, KafkaConsumer<String, byte[]> consumer, String topicStr) {
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        List partitions = consumer.partitionsFor(topicStr);
        for (PartitionInfo partition : partitions) {
            TopicPartition topicPartition = new TopicPartition(topicStr, partition.partition());
            Option optionOffset = zkClient.getConsumerOffset(this.groupId, topicPartition);
            if (!optionOffset.nonEmpty()) continue;
            Long offset = (Long)optionOffset.get();
            OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(offset.longValue());
            offsets.put(topicPartition, offsetAndMetadata);
        }
        return offsets;
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    private List<KafkaInfo> loadPositionFile(String filePath) {
        ArrayList<KafkaInfo> arrayList;
        Throwable throwable;
        FileReader fr;
        block42: {
            block43: {
                ArrayList<KafkaInfo> kafkaInfoList = new ArrayList<KafkaInfo>();
                fr = new FileReader(filePath);
                throwable = null;
                if (fr.ready()) {
                    try (JsonReader jr = new JsonReader((Reader)fr);){
                        jr.beginArray();
                        while (jr.hasNext()) {
                            Integer partition = null;
                            Long offset = null;
                            String topic = null;
                            jr.beginObject();
                            while (jr.hasNext()) {
                                switch (jr.nextName()) {
                                    case "partition": {
                                        partition = jr.nextInt();
                                        break;
                                    }
                                    case "offset": {
                                        offset = jr.nextLong();
                                        break;
                                    }
                                    case "topic": {
                                        topic = jr.nextString();
                                    }
                                }
                            }
                            jr.endObject();
                            for (Object v : Arrays.asList(partition, offset, topic)) {
                                Preconditions.checkNotNull(v, (Object)("Detected missing value in position file. topic: " + topic + ", partition: " + partition + ", offset: " + offset));
                            }
                            KafkaInfo ki = new KafkaInfo(topic, partition, offset);
                            kafkaInfoList.add(ki);
                        }
                        jr.endArray();
                    }
                } else {
                    log.warn("File is empty: " + filePath + ", not updating position");
                }
                arrayList = kafkaInfoList;
                if (fr == null) break block42;
                if (throwable == null) break block43;
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block42;
            }
            fr.close();
        }
        return arrayList;
        catch (Throwable throwable3) {
            try {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (fr != null) {
                        if (throwable != null) {
                            try {
                                fr.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            fr.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (FileNotFoundException e) {
                log.info("File not found: " + filePath + ", not updating position");
                return null;
            }
            catch (Exception e) {
                log.error("Failed loading positionFile: " + filePath, (Throwable)e);
                return null;
            }
        }
    }

    private void putStartOffsetMap() {
        KafkaConsumer consumer = new KafkaConsumer(this.kafkaProps);
        List topics = (List)this.subscriber.get();
        for (String topic : topics) {
            List partitionInfos = consumer.partitionsFor(topic);
            for (PartitionInfo partitionInfo : partitionInfos) {
                TopicPartition topicPartition = new TopicPartition(topic, partitionInfo.partition());
                consumer.assign(Collections.singleton(topicPartition));
                long startOffset = consumer.position(topicPartition);
                log.info("[" + topic + "-" + partitionInfo.partition() + "] start offset:" + startOffset);
                this.startOffsetMap.putIfAbsent(topic + "_" + partitionInfo.partition(), startOffset);
            }
        }
    }

    private static class ConsumerStatistics
    implements Runnable {
        Logger logger = LoggerFactory.getLogger(ConsumerStatistics.class);
        KafkaConsumer<String, byte[]> consumer;

        ConsumerStatistics(KafkaConsumer<String, byte[]> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void run() {
            StringBuilder info = new StringBuilder();
            info.append("Kafka\u6d88\u8d39\u60c5\u51b5\u7edf\u8ba1\uff1a\n");
            Map topics = this.consumer.listTopics();
            for (Map.Entry entry : topics.entrySet()) {
                String topic = (String)entry.getKey();
                List partitionInfoList = (List)entry.getValue();
                for (PartitionInfo partitionInfo : partitionInfoList) {
                    int partition = partitionInfo.partition();
                    long position = this.consumer.position(new TopicPartition(topic, partition));
                    info.append("topic:").append(topic).append(",partition:").append(position).append(",position:").append(position).append(".\n");
                }
            }
            info.append("Kafka\u6d88\u8d39\u60c5\u51b5\u7edf\u8ba1\u5b8c\u6bd5\n");
            this.logger.info(info.toString());
        }
    }

    private class ChannelConsumer
    implements Runnable {
        private ChannelConsumer() {
        }

        @Override
        public void run() {
            try {
                StringBuilder stringBuilder = FlumeUtils.getChannelConsumerInfo((String)KafkaSource.this.getName());
                log.info(stringBuilder.toString());
            }
            catch (Exception e) {
                log.error("speedBalancer with error message : ", (Throwable)e);
            }
        }
    }

    private class CheckStateFileRunnable
    implements Runnable {
        private CheckStateFileRunnable() {
        }

        @Override
        public void run() {
            try {
                KafkaSource.this.checkStateFlag = CommonLock.checkStateFile();
            }
            catch (Exception e) {
                log.error("CheckStateFileRunnable Exception is :" + e.getMessage());
            }
        }
    }

    private static class PatternSubscriber
    extends Subscriber<Pattern> {
        private Pattern pattern;

        public PatternSubscriber(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public void subscribe(KafkaConsumer<?, ?> consumer, SourceRebalanceListener listener) {
            consumer.subscribe(this.pattern, (ConsumerRebalanceListener)listener);
        }

        @Override
        public Pattern get() {
            return this.pattern;
        }
    }

    private static class TopicListSubscriber
    extends Subscriber<List<String>> {
        private final List<String> topicList;

        public TopicListSubscriber(String commaSeparatedTopics) {
            this.topicList = Arrays.asList(commaSeparatedTopics.split("^\\s+|\\s*,\\s*|\\s+$"));
        }

        @Override
        public void subscribe(KafkaConsumer<?, ?> consumer, SourceRebalanceListener listener) {
            consumer.subscribe(this.topicList, (ConsumerRebalanceListener)listener);
        }

        @Override
        public List<String> get() {
            return this.topicList;
        }
    }

    public static abstract class Subscriber<T> {
        public abstract void subscribe(KafkaConsumer<?, ?> var1, SourceRebalanceListener var2);

        public T get() {
            return null;
        }
    }
}

