/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.customsource.taildir;

import cn.thinkingdata.ta.customsource.taildir.TailFile;
import cn.thinkingdata.ta.customsource.taildir.TaildirMatcher;
import cn.thinkingdata.ta.logbus.utils.CommonUtil;
import cn.thinkingdata.ta.logbus.utils.FileUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.client.avro.ReliableEventReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReliableTaildirEventReader
implements ReliableEventReader {
    private static final Logger logger = LoggerFactory.getLogger(ReliableTaildirEventReader.class);
    private List<TaildirMatcher> taildirCache;
    private final String matcher;
    private final Table<String, String, String> headerTable;
    private TailFile currentFile = null;
    private final Map<String, TailFile> tailFiles = Maps.newConcurrentMap();
    private long updateTime;
    private long taildirCacheOutTime;
    private final boolean addByteOffset;
    private final boolean cachePatternMatching;
    private boolean committed = true;
    private final boolean annotateFileName;
    private final String fileNameHeader;
    private final Map<String, String> filePaths;
    private final String sourceName;

    private ReliableTaildirEventReader(Map<String, String> filePaths, String matcher, Table<String, String, String> headerTable, String positionFilePath, boolean skipToEnd, boolean addByteOffset, boolean cachePatternMatching, boolean annotateFileName, String fileNameHeader, String sourceName) throws IOException {
        this.sourceName = sourceName;
        this.matcher = matcher;
        Preconditions.checkNotNull(filePaths);
        Preconditions.checkNotNull((Object)positionFilePath);
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing {} with directory={}, metaDir={}", new Object[]{ReliableTaildirEventReader.class.getSimpleName(), filePaths});
        }
        this.filePaths = filePaths;
        this.updateTailCache();
        this.headerTable = headerTable;
        this.addByteOffset = addByteOffset;
        this.cachePatternMatching = cachePatternMatching;
        this.annotateFileName = annotateFileName;
        this.fileNameHeader = fileNameHeader;
        this.taildirCacheOutTime = System.currentTimeMillis();
        this.updateTailFiles(skipToEnd);
        logger.info("Updating position from position file: " + positionFilePath);
        this.loadPositionFile(positionFilePath);
    }

    public void loadPositionFile(String filePath) {
        try {
            Map map = CommonUtil.loadPositionFile((String)filePath);
            for (Map.Entry entry : map.entrySet()) {
                String path = (String)entry.getKey();
                Long pos = (Long)entry.getValue();
                TailFile tf = this.tailFiles.get(path);
                if (tf != null && tf.updatePos(path, pos)) {
                    this.tailFiles.put(path, tf);
                    continue;
                }
                logger.info("Missing file: " + path + ", pos: " + pos);
                if (tf == null) continue;
                tf.close();
            }
        }
        catch (FileNotFoundException e) {
            logger.info("File not found: " + filePath + ", not updating position");
        }
        catch (Exception e) {
            logger.error("Failed loading positionFile: " + filePath, (Throwable)e);
        }
    }

    public Map<String, TailFile> getTailFiles() {
        return this.tailFiles;
    }

    public void setCurrentFile(TailFile currentFile) {
        this.currentFile = currentFile;
    }

    public Event readEvent() throws IOException {
        List<Event> events = this.readEvents(1);
        if (events.isEmpty()) {
            return null;
        }
        return events.get(0);
    }

    public List<Event> readEvents(int numEvents) throws IOException {
        return this.readEvents(numEvents, false);
    }

    @VisibleForTesting
    public List<Event> readEvents(TailFile tf, int numEvents) throws IOException {
        this.setCurrentFile(tf);
        return this.readEvents(numEvents, true);
    }

    public List<Event> readEvents(int numEvents, boolean backoffWithoutNL) throws IOException {
        List<Event> events;
        if (!this.committed) {
            if (this.currentFile == null) {
                throw new IllegalStateException("current file does not exist. ");
            }
            logger.info("Last read was never committed - resetting position");
            long lastPos = this.currentFile.getPos();
            this.currentFile.updateFilePos(lastPos);
        }
        if ((events = this.currentFile.readEvents(numEvents, backoffWithoutNL, this.addByteOffset, this.sourceName, this.annotateFileName, this.fileNameHeader)).isEmpty()) {
            return events;
        }
        this.committed = false;
        return events;
    }

    public void close() throws IOException {
        for (TailFile tf : this.tailFiles.values()) {
            if (tf.getRaf() == null) continue;
            tf.getRaf().close();
        }
    }

    public void commit() throws IOException {
        if (!this.committed && this.currentFile != null) {
            long pos = this.currentFile.getLineReadPos();
            this.currentFile.setPos(pos);
            this.currentFile.setLastUpdated(this.updateTime);
            this.committed = true;
        }
    }

    public void updateTailCache() {
        long curTime;
        ArrayList taildirCache = Lists.newArrayList();
        for (Map.Entry<String, String> e : this.filePaths.entrySet()) {
            List regexMatchFiles = FileUtil.analysisRegexPath((String)e.getValue(), (String)this.matcher);
            for (File file : regexMatchFiles) {
                String filePattern = file.getAbsolutePath();
                taildirCache.add(new TaildirMatcher(e.getKey(), filePattern, this.cachePatternMatching));
            }
        }
        if (taildirCache.size() < 10000 && (curTime = System.currentTimeMillis()) - this.taildirCacheOutTime > 600000L) {
            logger.info("taildirMatcher:" + this.matcher + ",taildirCache: " + ((Object)taildirCache).toString());
            this.taildirCacheOutTime = curTime;
        }
        logger.info("taildirMatcher:" + this.matcher + ",taildirCache size: " + taildirCache.size());
        if (this.headerTable != null) {
            logger.info("headerTable: " + this.headerTable);
        }
        this.taildirCache = taildirCache;
    }

    public List<String> updateTailFiles(boolean skipToEnd) throws IOException {
        this.updateTime = System.currentTimeMillis();
        ArrayList updatedPath = Lists.newArrayList();
        for (TaildirMatcher taildir : this.taildirCache) {
            Map headers = this.headerTable.row((Object)taildir.getFileGroup());
            for (File f : taildir.getMatchingFiles()) {
                String path = f.getAbsolutePath();
                TailFile tf = this.tailFiles.get(path);
                if (tf == null || !tf.getPath().equals(f.getAbsolutePath())) {
                    long startPos = skipToEnd ? f.length() : 0L;
                    tf = this.openFile(f, headers, startPos);
                } else {
                    boolean updated;
                    boolean bl = updated = tf.getLastUpdated() < f.lastModified() || tf.getPos() != f.length();
                    if (updated) {
                        if (tf.getRaf() == null) {
                            tf = this.openFile(f, headers, tf.getPos());
                        }
                        if (tf != null && f.length() < tf.getPos()) {
                            logger.info("Pos " + tf.getPos() + " is larger than file size:" + f.length() + "! Restarting from pos 0, file: " + tf.getPath());
                            tf.close();
                            tf = this.openFile(f, headers, skipToEnd ? f.length() : 0L);
                        }
                    }
                    if (tf != null) {
                        tf.setNeedTail(updated);
                    }
                }
                this.tailFiles.put(path, tf);
                updatedPath.add(path);
            }
        }
        return updatedPath;
    }

    public List<String> updateTailFiles() throws IOException {
        return this.updateTailFiles(false);
    }

    private TailFile openFile(File file, Map<String, String> headers, long pos) {
        try {
            long inode = CommonUtil.getInode((File)file);
            logger.info("Opening file: " + file + ", pos: " + pos + ", inode: " + inode);
            return new TailFile(file, headers, pos);
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                logger.error("Failed opening file: " + file, (Throwable)e);
                return null;
            }
            throw new FlumeException("Failed opening file: " + file, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> getRegexMatchFiles(File parentDir, DirectoryStream.Filter<Path> fileFilter) {
        ArrayList result = Lists.newArrayList();
        DirectoryStream<Path> stream = null;
        try {
            stream = Files.newDirectoryStream(parentDir.toPath(), fileFilter);
            for (Path entry : stream) {
                result.add(entry.toFile());
            }
        }
        catch (IOException e) {
            logger.error("get files with exception", (Throwable)e);
        }
        finally {
            try {
                if (null != stream) {
                    stream.close();
                }
            }
            catch (IOException e) {
                logger.warn("DirectoryStream close error\uff1a" + e);
            }
        }
        return result;
    }

    public static class Builder {
        private Map<String, String> filePaths;
        private String matcher;
        private Table<String, String, String> headerTable;
        private String positionFilePath;
        private boolean skipToEnd;
        private boolean addByteOffset;
        private boolean cachePatternMatching;
        private Boolean annotateFileName = false;
        private String fileNameHeader = "file";
        private String sourceName;

        public Builder filePaths(Map<String, String> filePaths) {
            this.filePaths = filePaths;
            return this;
        }

        public Builder matcher(String matcher) {
            this.matcher = matcher;
            return this;
        }

        public Builder headerTable(Table<String, String, String> headerTable) {
            this.headerTable = headerTable;
            return this;
        }

        public Builder positionFilePath(String positionFilePath) {
            this.positionFilePath = positionFilePath;
            return this;
        }

        public Builder skipToEnd(boolean skipToEnd) {
            this.skipToEnd = skipToEnd;
            return this;
        }

        public Builder addByteOffset(boolean addByteOffset) {
            this.addByteOffset = addByteOffset;
            return this;
        }

        public Builder cachePatternMatching(boolean cachePatternMatching) {
            this.cachePatternMatching = cachePatternMatching;
            return this;
        }

        public Builder annotateFileName(boolean annotateFileName) {
            this.annotateFileName = annotateFileName;
            return this;
        }

        public Builder fileNameHeader(String fileNameHeader) {
            this.fileNameHeader = fileNameHeader;
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public ReliableTaildirEventReader build() throws IOException {
            return new ReliableTaildirEventReader(this.filePaths, this.matcher, this.headerTable, this.positionFilePath, this.skipToEnd, this.addByteOffset, this.cachePatternMatching, this.annotateFileName, this.fileNameHeader, this.sourceName);
        }
    }
}

