/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.customsource.taildir;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TaildirMatcher {
    private static final Logger logger = LoggerFactory.getLogger(TaildirMatcher.class);
    private static final FileSystem FS = FileSystems.getDefault();
    private final boolean cachePatternMatching;
    private final String fileGroup;
    private final String filePattern;
    private final File parentDir;
    private final File file;
    private final DirectoryStream.Filter<Path> fileFilter;
    private long lastSeenParentDirMTime = -1L;
    private long lastCheckedTime = -1L;
    private List<File> lastMatchedFiles = Lists.newArrayList();

    TaildirMatcher(String fileGroup, String filePattern, boolean cachePatternMatching) {
        this.fileGroup = fileGroup;
        this.filePattern = filePattern;
        this.cachePatternMatching = cachePatternMatching;
        File f = new File(filePattern);
        File parentDir = f.getParentFile();
        if (!f.exists()) {
            this.file = null;
            while (!parentDir.isDirectory()) {
                f = parentDir;
                parentDir = f.getParentFile();
            }
            String regex = f.getName();
            PathMatcher matcher = FS.getPathMatcher("regex:" + regex);
            this.fileFilter = entry -> matcher.matches(entry.getFileName()) && !Files.isDirectory(entry, new LinkOption[0]) && Files.exists(entry, new LinkOption[0]) && !Files.isHidden(entry);
        } else {
            this.file = f;
            this.fileFilter = null;
        }
        this.parentDir = parentDir;
        Preconditions.checkState((boolean)parentDir.exists(), (Object)("Directory does not exist: " + parentDir.getAbsolutePath()));
    }

    List<File> getMatchingFiles() {
        boolean parentDirExistFlag;
        long now = TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        long currentParentDirMTime = this.parentDir.lastModified();
        if (!this.cachePatternMatching || this.lastSeenParentDirMTime < currentParentDirMTime || currentParentDirMTime >= this.lastCheckedTime) {
            this.lastMatchedFiles = TaildirMatcher.sortByLastModifiedTime(this.getMatchingFilesNoCache());
            this.lastSeenParentDirMTime = currentParentDirMTime;
            this.lastCheckedTime = now;
        }
        if (!(parentDirExistFlag = this.parentDir.exists()) && this.lastMatchedFiles.size() != 0) {
            this.lastMatchedFiles.clear();
        }
        return this.lastMatchedFiles;
    }

    private List<File> getMatchingFilesNoCache() {
        ArrayList result = Lists.newArrayList();
        if (this.file != null) {
            result.add(this.file);
            return result;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.parentDir.toPath(), this.fileFilter);){
            for (Path entry : stream) {
                result.add(entry.toFile());
            }
        }
        catch (IOException e) {
            logger.error("I/O exception occurred while listing parent directory. Files already matched will be returned. " + this.parentDir.toPath(), (Throwable)e);
        }
        return result;
    }

    private static List<File> sortByLastModifiedTime(List<File> files) {
        HashMap<File, Long> lastModificationTimes = new HashMap<File, Long>(files.size());
        for (File f : files) {
            lastModificationTimes.put(f, f.lastModified());
        }
        files.sort(Comparator.comparing(lastModificationTimes::get));
        return files;
    }

    public String toString() {
        return "{filegroup='" + this.fileGroup + '\'' + ", filePattern='" + this.filePattern + '\'' + ", cached=" + this.cachePatternMatching + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaildirMatcher that = (TaildirMatcher)o;
        return this.fileGroup.equals(that.fileGroup);
    }

    public int hashCode() {
        return this.fileGroup.hashCode();
    }

    public String getFileGroup() {
        return this.fileGroup;
    }
}

