/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.ta.customsource.taildir;

import cn.thinkingdata.ta.customsource.taildir.ReliableTaildirEventReader;
import cn.thinkingdata.ta.customsource.taildir.TailFile;
import cn.thinkingdata.ta.customsource.taildir.TaildirSourceConfigurationConstants;
import cn.thinkingdata.ta.logbus.utils.CommonLock;
import cn.thinkingdata.ta.logbus.utils.CommonUtil;
import cn.thinkingdata.ta.logbus.utils.FlumeUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.PollableSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaildirSource
extends AbstractSource
implements PollableSource,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(TaildirSource.class);
    private Map<String, String> filePaths;
    private Table<String, String, String> headerTable;
    private int batchSize;
    private String positionFilePath;
    private String matcher;
    private boolean skipToEnd;
    private boolean byteOffsetHeader;
    private SourceCounter sourceCounter;
    private ReliableTaildirEventReader reader;
    private ScheduledExecutorService idleFileChecker;
    private ScheduledExecutorService positionWriter;
    private ScheduledExecutorService dynamicFile;
    private ScheduledExecutorService channelConsumerScheduled;
    private ScheduledExecutorService checkStateFileService;
    private boolean checkStateFlag = false;
    private boolean isCanStop = false;
    private int retryInterval = 1000;
    private int maxRetryInterval = 5000;
    private int retardInterval = 1000;
    private boolean retardFlag = false;
    private int retardCount = 0;
    private int maxRetardInterval = 10000;
    private int idleTimeout;
    private int checkIdleInterval = 5000;
    private int writePosInitDelay = 5000;
    private int dynamicFileInterval = 60000;
    private int dynamicFileInitDelay = 5000;
    private int stateBalancerInterval = 30000;
    private int stateBalancerInitDelay = 5000;
    private int writePosInterval;
    private boolean cachePatternMatching;
    private final List<String> existingPaths = new CopyOnWriteArrayList<String>();
    private final Set<String> idlePaths = new CopyOnWriteArraySet<String>();
    private Long backoffSleepIncrement;
    private Long maxBackOffSleepInterval;
    private boolean fileHeader;
    private String fileHeaderKey;
    private Long maxBatchCount;
    private boolean isFileChannel = true;
    private boolean resetFlag;

    public synchronized void configure(Context context) {
        String fileGroups = context.getString("filegroups");
        Preconditions.checkState((fileGroups != null ? 1 : 0) != 0, (Object)"Missing param: filegroups");
        this.filePaths = this.selectByKeys((Map<String, String>)context.getSubProperties("filegroups."), fileGroups.split("\\s+"));
        Preconditions.checkState((!this.filePaths.isEmpty() ? 1 : 0) != 0, (Object)"Mapping for tailing files is empty or invalid: 'filegroups.'");
        String homePath = System.getProperty("user.home").replace('\\', '/');
        this.positionFilePath = context.getString("positionFile", homePath + "/.flume/taildir_position.json");
        if (!"file".equals(context.getString("channelType"))) {
            this.isFileChannel = false;
        }
        this.matcher = context.getString("matcher", "regex");
        Path positionFile = Paths.get(this.positionFilePath, new String[0]);
        try {
            Files.createDirectories(positionFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FlumeException("Error creating positionFile parent directories", (Throwable)e);
        }
        this.headerTable = this.getTable(context, "headers.");
        this.batchSize = context.getInteger("batchSize", Integer.valueOf(100));
        this.skipToEnd = context.getBoolean("skipToEnd", Boolean.valueOf(false));
        this.byteOffsetHeader = context.getBoolean("byteOffsetHeader", Boolean.valueOf(false));
        this.idleTimeout = context.getInteger("idleTimeout", Integer.valueOf(120000));
        this.writePosInterval = context.getInteger("writePosInterval", Integer.valueOf(3000));
        this.cachePatternMatching = context.getBoolean("cachePatternMatching", Boolean.valueOf(true));
        this.backoffSleepIncrement = context.getLong("backoffSleepIncrement", Long.valueOf(1000L));
        this.maxBackOffSleepInterval = context.getLong("maxBackoffSleep", Long.valueOf(5000L));
        this.fileHeader = context.getBoolean("fileHeader", Boolean.valueOf(false));
        this.fileHeaderKey = context.getString("fileHeaderKey", "file");
        this.resetFlag = CommonUtil.getResetFlagByFile();
        this.maxBatchCount = context.getLong("maxBatchCount", TaildirSourceConfigurationConstants.DEFAULT_MAX_BATCH_COUNT);
        if (this.maxBatchCount <= 0L) {
            this.maxBatchCount = TaildirSourceConfigurationConstants.DEFAULT_MAX_BATCH_COUNT;
            logger.warn("Invalid maxBatchCount specified, initializing source default maxBatchCount of {}", (Object)this.maxBatchCount);
        }
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    public synchronized void start() {
        logger.info("{} TaildirSource source starting with directory: {}", (Object)this.getName(), this.filePaths);
        try {
            this.reader = new ReliableTaildirEventReader.Builder().filePaths(this.filePaths).matcher(this.matcher).headerTable(this.headerTable).positionFilePath(this.positionFilePath).skipToEnd(this.skipToEnd).addByteOffset(this.byteOffsetHeader).cachePatternMatching(this.cachePatternMatching).annotateFileName(this.fileHeader).fileNameHeader(this.fileHeaderKey).sourceName(this.getName()).build();
        }
        catch (IOException e) {
            throw new FlumeException("Error instantiating ReliableTaildirEventReader", (Throwable)e);
        }
        this.idleFileChecker = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("IdleFileChecker-" + this.getName()).build());
        this.idleFileChecker.scheduleWithFixedDelay(new IdleFileCheckerRunnable(), this.idleTimeout, this.checkIdleInterval, TimeUnit.MILLISECONDS);
        if (this.isFileChannel) {
            this.positionWriter = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("PositionWriter-" + this.getName()).build());
            this.positionWriter.scheduleWithFixedDelay(new PositionWriterRunnable(), this.writePosInitDelay, this.writePosInterval, TimeUnit.MILLISECONDS);
        }
        this.dynamicFile = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("DynamicFile-" + this.getName()).build());
        this.dynamicFile.scheduleWithFixedDelay(new DynamicFileRunnable(), this.dynamicFileInitDelay, this.dynamicFileInterval, TimeUnit.MILLISECONDS);
        this.channelConsumerScheduled = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("Source-StateBalancerScheduledExecutorService-" + this.getName()).setDaemon(true).build());
        this.channelConsumerScheduled.scheduleWithFixedDelay(new ChannelConsumer(), this.stateBalancerInitDelay, this.stateBalancerInterval, TimeUnit.MILLISECONDS);
        this.checkStateFileService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("Source-CheckStateFileService-" + this.getName()).daemon(true).build());
        this.checkStateFileService.scheduleWithFixedDelay(new CheckStateFileRunnable(), 5L, 3L, TimeUnit.SECONDS);
        super.start();
        logger.debug("TaildirSource started");
        this.sourceCounter.start();
        CommonLock.recordStartCounter((String)this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollableSource.Status process() {
        PollableSource.Status status = PollableSource.Status.BACKOFF;
        if (this.checkStateFlag) {
            CommonLock.recordStopCounter((String)this.getName());
            this.isCanStop = true;
            return PollableSource.Status.BACKOFF;
        }
        if (this.resetFlag) {
            try {
                TimeUnit.MILLISECONDS.sleep(10000L);
                logger.info("\u91cd\u7f6efile channel\uff0c\u4e0d\u8bfb\u53d6\u6570\u636e");
            }
            catch (InterruptedException e) {
                logger.info("Interrupted while sleeping");
            }
            return PollableSource.Status.BACKOFF;
        }
        try {
            Class<TaildirSource> e = TaildirSource.class;
            synchronized (TaildirSource.class) {
                this.existingPaths.clear();
                this.existingPaths.addAll(this.reader.updateTailFiles());
                // ** MonitorExit[e] (shouldn't be in output)
                for (String path : this.existingPaths) {
                    TailFile tf = this.reader.getTailFiles().get(path);
                    if (!tf.needTail()) continue;
                    if (this.checkStateFlag) {
                        CommonLock.recordStopCounter((String)this.getName());
                        this.isCanStop = true;
                        status = PollableSource.Status.BACKOFF;
                        break;
                    }
                    boolean hasMoreLines = this.tailFileProcess(tf, true);
                    if (!hasMoreLines) continue;
                    status = PollableSource.Status.READY;
                }
                this.closeTailFiles();
            }
        }
        catch (Throwable t) {
            logger.error("Unable to tail files", t);
            this.sourceCounter.incrementEventReadFail();
            status = PollableSource.Status.BACKOFF;
        }
        return status;
    }

    public synchronized void stop() {
        this.checkStateFlag = true;
        int count = 0;
        while (!this.isCanStop && count < 300) {
            try {
                Thread.sleep(1000L);
                ++count;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            ExecutorService[] services;
            super.stop();
            for (ExecutorService service : services = new ExecutorService[]{this.idleFileChecker, this.positionWriter, this.dynamicFile, this.channelConsumerScheduled, this.checkStateFileService}) {
                if (service == null) continue;
                service.shutdown();
                if (service.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                service.shutdownNow();
            }
            if (this.isFileChannel) {
                this.writePosition();
            }
            this.reader.close();
        }
        catch (InterruptedException e) {
            logger.info("Interrupted while awaiting termination", (Throwable)e);
        }
        catch (IOException e) {
            logger.info("Failed: " + e.getMessage(), (Throwable)e);
        }
        this.sourceCounter.stop();
        logger.info("Taildir source {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.sourceCounter);
    }

    public String toString() {
        return String.format("Taildir source: { positionFile: %s, skipToEnd: %s, byteOffsetHeader: %s, idleTimeout: %s, writePosInterval: %s }", this.positionFilePath, this.skipToEnd, this.byteOffsetHeader, this.idleTimeout, this.writePosInterval);
    }

    private Map<String, String> selectByKeys(Map<String, String> map, String[] keys) {
        HashMap result = Maps.newHashMap();
        for (String key : keys) {
            if (!map.containsKey(key)) continue;
            result.put(key, map.get(key));
        }
        return result;
    }

    private Table<String, String, String> getTable(Context context, String prefix) {
        HashBasedTable table = HashBasedTable.create();
        for (Map.Entry e : context.getSubProperties(prefix).entrySet()) {
            String[] parts = ((String)e.getKey()).split("\\.", 2);
            table.put((Object)parts[0], (Object)parts[1], e.getValue());
        }
        return table;
    }

    @VisibleForTesting
    protected SourceCounter getSourceCounter() {
        return this.sourceCounter;
    }

    public long getBackOffSleepIncrement() {
        return this.backoffSleepIncrement;
    }

    public long getMaxBackOffSleepInterval() {
        return this.maxBackOffSleepInterval;
    }

    private boolean tailFileProcess(TailFile tf, boolean backoffWithoutNL) throws IOException {
        long batchCount = 0L;
        while (true) {
            if (this.checkStateFlag) {
                CommonLock.recordStopCounter((String)this.getName());
                this.isCanStop = true;
                logger.info("The logbus will exit !");
                return false;
            }
            if (!this.isFileChannel && this.retardCount > 50) {
                FlumeUtils.stopFlume();
                return false;
            }
            try {
                this.retardFlag = FlumeUtils.whetherNeedChannelBalance((String)this.getName());
                if (this.retardFlag) {
                    this.retardInterval <<= 1;
                    this.retardInterval = Math.min(this.retardInterval, this.maxRetardInterval);
                    logger.info("Channel \u672a\u6d88\u8d39\u603b\u91cf\u8fc7\u5927 \uff0c" + this.getName() + " \u4f11\u7720 " + this.retardInterval + " ms");
                    TimeUnit.MILLISECONDS.sleep(this.retardInterval);
                    ++this.retardCount;
                    continue;
                }
                this.retardInterval = 1000;
                this.retardCount = 0;
            }
            catch (Exception e) {
                logger.error("\u7edf\u8ba1\u6d88\u8d39\u901f\u7387\u5931\u8d25\uff01", (Throwable)e);
            }
            this.reader.setCurrentFile(tf);
            List<Event> events = this.reader.readEvents(this.batchSize, backoffWithoutNL);
            if (events.isEmpty()) {
                return false;
            }
            this.sourceCounter.addToEventReceivedCount((long)events.size());
            this.sourceCounter.incrementAppendBatchReceivedCount();
            try {
                this.getChannelProcessor().processEventBatch(events);
                this.reader.commit();
            }
            catch (Throwable t) {
                logger.error("process to channel error :" + t.getMessage(), t);
                logger.error("The channel is full or unexpected failure. The source will try again after " + this.retryInterval + " ms");
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryInterval);
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while sleeping" + e);
                }
                this.retryInterval <<= 1;
                this.retryInterval = Math.min(this.retryInterval, this.maxRetryInterval);
                continue;
            }
            this.retryInterval = 1000;
            this.sourceCounter.addToEventAcceptedCount((long)events.size());
            this.sourceCounter.incrementAppendBatchAcceptedCount();
            if (this.checkStateFlag) {
                CommonLock.recordStopCounter((String)this.getName());
                this.isCanStop = true;
                logger.info("The logbus will exit !");
                return false;
            }
            if (events.size() < this.batchSize) {
                logger.info("The events taken from " + tf.getPath() + " is less than " + this.batchSize);
                return false;
            }
            if (++batchCount >= this.maxBatchCount) break;
        }
        logger.info("The batches read from the same file is larger than " + this.maxBatchCount);
        return true;
    }

    private void closeTailFiles() throws IOException {
        for (String path : this.idlePaths) {
            TailFile tf = this.reader.getTailFiles().get(path);
            if (tf.getRaf() == null) continue;
            this.tailFileProcess(tf, false);
            tf.close();
            logger.info("Closed file: " + tf.getPath() + ", pos: " + tf.getPos());
        }
        this.idlePaths.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePosition() {
        if (!this.isFileChannel) {
            return;
        }
        File file = new File(this.positionFilePath);
        try {
            Class<TaildirSource> clazz = TaildirSource.class;
            synchronized (TaildirSource.class) {
                if (!this.existingPaths.isEmpty()) {
                    String json = this.toPosInfoJson();
                    FileUtils.write((File)file, (CharSequence)json, (String)"UTF-8", (boolean)false);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Throwable t) {
            logger.error("Failed writing positionFile", t);
        }
        {
            return;
        }
    }

    private String toPosInfoJson() {
        ArrayList posInfos = Lists.newArrayList();
        for (String path : this.existingPaths) {
            TailFile tf = this.reader.getTailFiles().get(path);
            posInfos.add(ImmutableMap.of((Object)"pos", (Object)tf.getPos(), (Object)"file", (Object)tf.getPath()));
        }
        return new Gson().toJson((Object)posInfos);
    }

    private class ChannelConsumer
    implements Runnable {
        private ChannelConsumer() {
        }

        @Override
        public void run() {
            try {
                StringBuilder stringBuilder = FlumeUtils.getChannelConsumerInfo((String)TaildirSource.this.getName());
                logger.info(stringBuilder.toString());
            }
            catch (Exception e) {
                logger.error("\u7edf\u8ba1\u6d88\u8d39\u901f\u7387\u5931\u8d25\uff01", (Throwable)e);
            }
        }
    }

    private class DynamicFileRunnable
    implements Runnable {
        private DynamicFileRunnable() {
        }

        @Override
        public void run() {
            logger.info("Start to update tail catch file!");
            logger.warn("\u76d1\u63a7\u76ee\u5f55\u7684\u6587\u4ef6\u4e2a\u6570\u8d85\u8fc7\u9879\u76ee\u4e0d\u66f4\u65b0\u6587\u4ef6\u5217\u8868,\u8bf7\u4f18\u5316\u5b9a\u65f6\u5220\u9664\u6587\u4ef6\u914d\u7f6e");
            try {
                TaildirSource.this.reader.updateTailCache();
            }
            catch (Throwable t) {
                logger.error("\u66f4\u65b0\u76d1\u63a7\u76ee\u5f55\u6587\u4ef6\u5931\u8d25\uff01", t);
            }
            logger.info("End update tail catch file!");
        }
    }

    private class CheckStateFileRunnable
    implements Runnable {
        private CheckStateFileRunnable() {
        }

        @Override
        public void run() {
            try {
                if (!TaildirSource.this.checkStateFlag) {
                    TaildirSource.this.checkStateFlag = CommonLock.checkStateFile();
                    if (TaildirSource.this.checkStateFlag) {
                        logger.info(TaildirSource.this.getName() + " \u6536\u5230\u505c\u6b62\u4fe1\u53f7\uff01");
                    }
                }
            }
            catch (Exception e) {
                logger.error("CheckStateFileRunnable Exception is :" + e.getMessage());
            }
        }
    }

    private class PositionWriterRunnable
    implements Runnable {
        private PositionWriterRunnable() {
        }

        @Override
        public void run() {
            TaildirSource.this.writePosition();
        }
    }

    private class IdleFileCheckerRunnable
    implements Runnable {
        private IdleFileCheckerRunnable() {
        }

        @Override
        public void run() {
            try {
                long now = System.currentTimeMillis();
                for (TailFile tf : TaildirSource.this.reader.getTailFiles().values()) {
                    if (tf.getLastUpdated() + (long)TaildirSource.this.idleTimeout >= now || tf.getRaf() == null) continue;
                    TaildirSource.this.idlePaths.add(tf.getPath());
                }
            }
            catch (Throwable t) {
                logger.error("Uncaught exception in IdleFileChecker thread", t);
            }
        }
    }
}

