#!/usr/bin/env bash

current=`pwd`
bin=$(cd "$(dirname "$0")";pwd)
source $bin/check_java
WORK_DIR=$bin/../

LIB=$WORK_DIR/lib/tga-logBus-lib
CLASSPATH=$(JARS=("$LIB"/ta-*.jar); IFS=:; echo "${JARS[*]}")
LOG_PATH=$WORK_DIR/log
TA_LOGBUS_CONFIG_FILE=$WORK_DIR/conf/logBus.conf


JAVA=$_java
JAVA_MAIN_CLASS="cn.thinkingdata.ta.logbus.main.LogBusApplication"
JAVA_JVM_ARGS="-classpath $CLASSPATH \
  -Dta.log.dir=$LOG_PATH \
  -Dta.work.dir=$WORK_DIR \
  -Dta.log.file=logbus.log  \
  -Dta.log.conf=$TA_LOGBUS_CONFIG_FILE \
  -Dfile.encoding=UTF-8 \
  -Xms20m -Xmx200m \
  -server -XX:+UseG1GC \
  "
nohup  "$JAVA" ${JAVA_JVM_ARGS} ${JAVA_MAIN_CLASS} "$@"  > /dev/null 2>&1 < /dev/null &