# Generated by Django 2.2.7 on 2019-12-06 08:07

import assets.models.asset
from django.db import migrations, models
import django.db.models.deletion


def migrate_platform_to_asset_type(apps, schema_editor):
    asset_model = apps.get_model("assets", "Asset")
    platform_model = apps.get_model("assets", "Platform")
    db_alias = schema_editor.connection.alias

    platforms = platform_model.objects.using(db_alias).all()
    platforms_map = {p.name: p for p in platforms}
    for name, p in platforms_map.items():
        asset_model.objects.using(db_alias)\
            .filter(_platform=name)\
            .update(platform=p)


class Migration(migrations.Migration):

    dependencies = [
        ('assets', '0044_platform'),
    ]

    operations = [
        migrations.RenameField(
            model_name='asset',
            old_name='platform',
            new_name='_platform',
        ),
        migrations.AddField(
            model_name='asset',
            name='platform',
            field=models.ForeignKey(
                default=assets.models.asset.Platform.default,
                on_delete=django.db.models.deletion.PROTECT,
                related_name='assets', to='assets.Platform',
                verbose_name='Platform'),
        ),
        migrations.RunPython(migrate_platform_to_asset_type),
        migrations.RemoveField(
            model_name='asset',
            name='_platform',
        ),
    ]
