# Generated by Django 3.1.12 on 2021-09-07 09:20

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('terminal', '0039_auto_20210805_1552'),
    ]

    operations = [
        migrations.CreateModel(
            name='SessionSharing',
            fields=[
                ('org_id', models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_by', models.CharField(blank=True, max_length=32, null=True, verbose_name='Created by')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date updated')),
                ('verify_code', models.CharField(max_length=16, verbose_name='Verify code')),
                ('is_active', models.BooleanField(db_index=True, default=True, verbose_name='Active')),
                ('expired_time', models.IntegerField(db_index=True, default=0, verbose_name='Expired time (min)')),
                ('creator', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Creator')),
                ('session', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='terminal.session', verbose_name='Session')),
            ],
            options={
                'ordering': ('-date_created',),
            },
        ),
        migrations.CreateModel(
            name='SessionJoinRecord',
            fields=[
                ('org_id', models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_by', models.CharField(blank=True, max_length=32, null=True, verbose_name='Created by')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date updated')),
                ('verify_code', models.CharField(max_length=16, verbose_name='Verify code')),
                ('date_joined', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='Date joined')),
                ('date_left', models.DateTimeField(db_index=True, null=True, verbose_name='Date left')),
                ('remote_addr', models.CharField(blank=True, db_index=True, max_length=128, null=True, verbose_name='Remote addr')),
                ('login_from', models.CharField(choices=[('ST', 'SSH Terminal'), ('RT', 'RDP Terminal'), ('WT', 'Web Terminal')], default='WT', max_length=2, verbose_name='Login from')),
                ('is_success', models.BooleanField(db_index=True, default=True, verbose_name='Success')),
                ('reason', models.CharField(blank=True, default='-', max_length=1024, null=True, verbose_name='Reason')),
                ('is_finished', models.BooleanField(db_index=True, default=False, verbose_name='Finished')),
                ('joiner', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Joiner')),
                ('session', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='terminal.session', verbose_name='Session')),
                ('sharing', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='terminal.sessionsharing', verbose_name='Session sharing')),
            ],
            options={
                'ordering': ('-date_joined',),
            },
        ),
    ]
