# Generated by BaiJiangjie 2020-09-29 18:31

from django.db import migrations


def migrate_ticket_meta_confirmed_system_user_to_confirmed_system_users(apps, schema_editor):
    ticket_model = apps.get_model("tickets", "Ticket")
    tickets = ticket_model.origin_objects.all()

    for ticket in tickets:
        meta = ticket.meta
        confirmed_system_user = meta.get('confirmed_system_user')
        if confirmed_system_user:
            confirmed_system_users = [confirmed_system_user]
        else:
            confirmed_system_users = []
        meta.update({
            'confirmed_system_users': confirmed_system_users
        })
        ticket.meta = meta
        ticket.save()


class Migration(migrations.Migration):

    dependencies = [
        ('tickets', '0004_ticket_comment'),
    ]
    operations = [
        migrations.RunPython(migrate_ticket_meta_confirmed_system_user_to_confirmed_system_users)
    ]
